<?php
// aes_runtime.php — AES-256-GCM wrapper (يشفر بنفس المفتاح الذي يرجعه endpoint)

if (!defined('UA_AES_AUTO') || !UA_AES_AUTO) return;
if (!extension_loaded('openssl')) return;

define('UA_AES_KEYFILE', __DIR__.'/.aes_key.bin');
define('UA_AES_SETTINGS', __DIR__.'/settings.json');

function ua_aes_settings(){
  static $S=null; if($S!==null) return $S;
  $S = is_file(UA_AES_SETTINGS) ? (json_decode(@file_get_contents(UA_AES_SETTINGS), true) ?: []) : [];
  if (empty($S['aes'])) $S['aes'] = ['enabled'=>false,'key_lifetime_days'=>7];
  return $S;
}
function ua_aes_enabled(){
  $s = ua_aes_settings();
  // نتعامل مع true/false أو "true"/"false"
  return filter_var($s['aes']['enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
}
function ua_aes_get_key(){
  $s = ua_aes_settings();
  $days = max(1, (int)($s['aes']['key_lifetime_days'] ?? 7));

  // نفس صيغة الملف التي يستخدمها الـ endpoint
  if (is_file(UA_AES_KEYFILE)) {
    $raw = @file_get_contents(UA_AES_KEYFILE);
    if ($raw && strlen($raw) >= 42) {
      $exp = (int)substr($raw,0,10);
      $key = substr($raw,10);
      if ($exp > time() && strlen($key) === 32) return $key;
    }
  }
  // توليد جديد (في حال عدم وجوده) — نفس منطق endpoint
  $key = random_bytes(32);
  $exp = time() + $days*24*3600;
  @file_put_contents(UA_AES_KEYFILE, str_pad((string)$exp,10,'0',STR_PAD_LEFT).$key, LOCK_EX);
  @chmod(UA_AES_KEYFILE, 0600);
  return $key;
}

ob_start(function($html){
  if (!ua_aes_enabled()) return $html;
  if (headers_sent())   return $html; // أمان

  $key = ua_aes_get_key();                 // ← نفس المفتاح اللي endpoint بيرجعه
  if (!$key || strlen($key)!==32) return $html;

  $iv  = random_bytes(12);                 // GCM IV 12 bytes
  $tag = '';
  $cipher = openssl_encrypt($html, 'aes-256-gcm', $key, OPENSSL_RAW_DATA, $iv, $tag);
  if ($cipher === false) return $html;

  // WebCrypto بيقبل (cipher || tag)
  $payload_b64 = base64_encode($cipher.$tag);
  $iv_b64      = base64_encode($iv);

  // عدّل المسار لو لوحة الإدارة في مجلد آخر
  $endpoint = 'admin.php?a=aes_key';

  // منع الكاش الوسيط
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
  header('Pragma: no-cache');

  return "<!doctype html><html><head><meta charset='utf-8'><title>Loading…</title></head><body>
<div id='aes_app'></div>
<script>
(function(){
  function b64ToBuf(b){var s=atob(b),l=s.length,u=new Uint8Array(l);for(var i=0;i<l;i++)u[i]=s.charCodeAt(i);return u.buffer;}
  (async function(){
    try{
      var r=await fetch('{$endpoint}',{credentials:'include',cache:'no-store'});
      if(!r.ok){document.getElementById('aes_app').textContent='Key unavailable';return;}
      var j=await r.json();
      if(!j||!j.key){document.getElementById('aes_app').textContent='Key missing';return;}
      var keyBuf=b64ToBuf(j.key);
      var k=await crypto.subtle.importKey('raw',keyBuf,{name:'AES-GCM'},false,['decrypt']);
      var iv=new Uint8Array(b64ToBuf('{$iv_b64}'));
      var payload=new Uint8Array(b64ToBuf('{$payload_b64}'));
      var plain=await crypto.subtle.decrypt({name:'AES-GCM',iv:iv},k,payload);
      var dec=new TextDecoder(); document.open(); document.write(dec.decode(plain)); document.close();
    }catch(e){
      console.error('AES decrypt error:', e);
      document.getElementById('aes_app').textContent='Decrypt error';
    }
  })();
})();
</script></body></html>";
});
