/* Ultra Admin – Controller (with Builder, File Editor, Picker, Neon Logs) */

document.addEventListener("DOMContentLoaded", () => {
  const m = document.getElementById("modalEditor");
  const e = document.getElementById("fileEditor");
  if (!m || !e) {
    console.warn("⚠️ modalEditor أو fileEditor غير جاهزين وقت التحميل");
  } else {
    console.log("✅ modalEditor و fileEditor تم تحميلهم بنجاح");
  }
});

(function(){
  'use strict';

  // injected from PHP at serve time
  var ADMIN_PASSWORD = __ADMIN_PASSWORD_PLACEHOLDER__;

  /* ================= Neon Debug Logger ================= */
  var UA_DBG = (function(){
    var TAG = '%c[Ultra Admin]%c';
    var S1  = 'background:#0ff;color:#111;padding:2px 6px;border-radius:4px 0 0 4px;font-weight:700';
    var S2  = 'background:#222;color:#0ff;padding:2px 6px;border-radius:0 4px 4px 0';
    function log(){ try{ console.log.apply(console,[TAG,S1,S2].concat([].slice.call(arguments))); }catch(e){} }
    function info(){ try{ console.info.apply(console,[TAG,S1,S2].concat([].slice.call(arguments))); }catch(e){} }
    function warn(){ try{ console.warn.apply(console,[TAG,S1,S2].concat([].slice.call(arguments))); }catch(e){} }
    function error(){ try{ console.error.apply(console,[TAG,S1,S2].concat([].slice.call(arguments))); }catch(e){} }
    function group(label){ try{ console.group(TAG+' '+label, S1,S2); }catch(e){} }
    function groupEnd(){ try{ console.groupEnd(); }catch(e){} }
    return {log:log,info:info,warn:warn,error:error,group:groupEnd,groupEnd:groupEnd};
  })();

  /* ================= helpers & UI bits ================= */
  function $(s){ return document.querySelector(s); }
  function $all(s){ return [].slice.call(document.querySelectorAll(s)); }
  function toast(msg, cls){
    try{
      var el=document.createElement('div');
      el.className='ua-toast '+(cls?('ua-'+cls):'ua-success');
      el.textContent=msg;
      document.body.appendChild(el);
      setTimeout(function(){el.classList.add('show')},10);
      setTimeout(function(){el.classList.remove('show'); setTimeout(function(){el.remove()},220)},2200);
    }catch(e){ UA_DBG.warn('[toast-fallback]', msg); }
  }
  function showLogin(){ $('#login')?.classList.remove('ua-hide'); $('#app')?.classList.add('ua-hide'); }
  function showApp(){   $('#login')?.classList.add('ua-hide');   $('#app')?.classList.remove('ua-hide'); }

  // global-ish state
  window.SETTINGS = null;
  window.currentPageIndex = 0;
  var currentForm = '', currentWidget = '';
  var __UA_LAST_PICK = null; // filled by picker.js via postMessage

  function j(url, method, body, headers){
    return fetch(url,{
      method: method||'GET',
      headers: headers || (body ? {'Content-Type':'application/json'} : undefined),
      body: body ? (typeof body==='string'? body : JSON.stringify(body)) : undefined,
      cache: 'no-store'
    });
  }
  function safeJson(url){
    return j(url).then(function(r){ return r.json(); }).catch(function(e){
      UA_DBG.error('safeJson failed for', url, e);
      return {};
    });
  }

  function loadSettings(){
    return safeJson('settings.json?ts='+Date.now()).then(function(s){
      window.SETTINGS = s || {};
      SETTINGS.theme    = SETTINGS.theme    || {};
      SETTINGS.telegram = SETTINGS.telegram || {};
      SETTINGS.widgets  = SETTINGS.widgets  || {};
      SETTINGS.forms    = SETTINGS.forms    || {};
      SETTINGS.pages    = Array.isArray(SETTINGS.pages) ? SETTINGS.pages : [];
      SETTINGS.antibot  = SETTINGS.antibot  || {enabled_global:false,apply_pages:[],js_rules:'',php_rules:''};
      (SETTINGS.pages||[]).forEach(function(p){
        if(!Array.isArray(p.regions_order)){ p.regions_order = Object.keys(p.regions||{}); }
        if(!p.forms_wrapper) p.forms_wrapper = {};
        if(!p.builder) p.builder = {draggable_marked:[]};
      });
    });
  }
  function saveSection(k,v){ return j('admin.php?save_section='+encodeURIComponent(k), 'POST', v); }
  function savePages(){   return saveSection('pages',   SETTINGS.pages||[]); }
  function saveForms(){   return saveSection('forms',   SETTINGS.forms||{}); }
  function saveWidgets(){ return saveSection('widgets', SETTINGS.widgets||{}); }
  function saveTheme(){   return saveSection('theme',   SETTINGS.theme||{}); }
  function saveTelegram(){return saveSection('telegram',SETTINGS.telegram||{}); }

  /* ================= LOGIN ================= */
  function bindLogin(){
    var btn=$('#btnLogin'), pass=$('#pass'), msg=$('#msg');
    if(!btn || !pass) return false;
    function doLogin(){
      var p=(pass.value||'').trim();
      if(!p){ msg.textContent='Enter password'; return; }
      if(p===ADMIN_PASSWORD){
        localStorage.setItem('ultra_admin_ok','1');
        msg.textContent='';
        afterLogin();
      }else{
        msg.textContent='Wrong password';
        pass.value='';
      }
    }
    btn.addEventListener('click', doLogin);
    pass.addEventListener('keydown', function(e){ if(e.key==='Enter') doLogin(); });
    return true;
  }

  /* ================= Region Picker integration ================= */
  // استقبال PICK + SAVE فقط من المصادر الصحيحة
  window.addEventListener('message', function(ev){
    if(!ev || !ev.data) return;

    // 1) استقبال اختيار من pickerFrame فقط
    if(ev.data.type==='UA_PICK'){
      var pf = document.getElementById('pickerFrame');
      if (!pf || ev.source !== (pf.contentWindow||pf.contentDocument)) {
        UA_DBG.warn('UA_PICK ignored (wrong source)');
        return;
      }
      UA_DBG.info('UA_PICK received', ev.data);

      __UA_LAST_PICK = {
        xpath: ev.data.xpath||'',
        css:   ev.data.css||'',
        id:    ev.data.id||'',
        mode:  ev.data.mode||'inside',
        point: ev.data.point||null
      };

      // تحديث عناصر المودال (إن لزم)
      populatePickFormSelect();
      $('#pick_region') && ($('#pick_region').value = 'main');

      // تأكد أن المودال مفتوح
      if(window.bootstrap && $('#modalPicker') && !$('#modalPicker').classList.contains('show')){
        new bootstrap.Modal('#modalPicker').show();
      }
      return;
    }

    // 2) حفظ Snapshot من المعاينة فقط
    if (ev.data.type === 'UA_DOM_SAVE') {
      var pv = document.querySelector('#pagePreview iframe');
      if (!pv || ev.source !== (pv.contentWindow||pv.contentDocument)) return;

      var pg=(SETTINGS.pages||[])[window.currentPageIndex];
      if(!pg){ toast('No page selected','warning'); return; }

      var fd = new FormData();
      fd.append('filename', pg.php||'');
      fd.append('html', ev.data.html||'');

      fetch('admin.php?save_page_file=1', {method:'POST', body:fd})
        .then(function(r){ return r.json(); })
        .then(function(x){
          if(x && x.ok){ toast('Saved snapshot'); renderPagePreview(); }
          else{ toast('Save failed','danger'); }
        })
        .catch(function(e){ UA_DBG.error('Snapshot save error', e); toast('Save error','danger'); });
      return;
    }
  });

  function populatePickFormSelect(){
    var sel = $('#pick_form');
    if(!sel) return;
    var forms = Object.keys(SETTINGS.forms||{}).filter(function(k){return k!=='__order';});
    sel.innerHTML = forms.map(function(n){ return '<option value="'+n+'">'+n+'</option>'; }).join('') || '<option value="">(No forms)</option>';
  }

  // زر Place — بدون تغيير منطقي، فقط يعتمد على __UA_LAST_PICK المحدث
  function wirePickerApply(){
    var btn = document.querySelector('#place') || document.querySelector('#pickApply');
    if(!btn) return;
    btn.addEventListener('click', function(e){
      e && e.preventDefault && e.preventDefault();
      e && e.stopPropagation && e.stopPropagation();

      var pg=(SETTINGS.pages||[])[window.currentPageIndex];
      if(!pg){ toast('No page selected','warning'); return; }
      if(!__UA_LAST_PICK){ toast('No picked target','warning'); return; }

      var region = ($('#pick_region') && $('#pick_region').value.trim()) || 'main';
      var form   = ($('#pick_form')   && $('#pick_form').value.trim())   || '';

      var fd = new FormData();
      fd.append('filename', pg.php||'');
      fd.append('region', region);
      fd.append('xpath', __UA_LAST_PICK.xpath || '');
      fd.append('css',   __UA_LAST_PICK.css   || '');
      fd.append('id',    __UA_LAST_PICK.id    || '');
      fd.append('mode',  __UA_LAST_PICK.mode  || 'inside');

      fetch('admin.php?mark_region=1', {method:'POST', body:fd})
        .then(function(r){return r.text().then(function(t){ try{return JSON.parse(t);}catch(_){return {ok:false, err:'Non-JSON response', raw:t}; } });})
        .then(function(x){
          if(!x || !x.ok){ toast('Mark failed: '+(x && (x.err||x.raw)||'unknown'),'danger'); UA_DBG.error('mark_region failed', x); return; }

          var regs = pg.regions || {};
          regs[region] = form ? {type:'form', form: form} : {type:'html', content:''};
          pg.regions = regs;

          pg.regions_order = Array.isArray(pg.regions_order) ? pg.regions_order.slice() : [];
          if(pg.regions_order.indexOf(region)===-1) pg.regions_order.push(region);

          SETTINGS.pages[window.currentPageIndex] = pg;
          savePages().then(function(){
            renderPageEditor(); renderPagePreview();
            alert('✔️ Placed at region "'+region+'" with mode "'+(__UA_LAST_PICK.mode||'inside')+'".');
            try{
              var m = bootstrap.Modal.getInstance($('#modalPicker')); m && m.hide();
            }catch(_){}
            toast('Region marked');
          });
        })
        .catch(function(e){
          UA_DBG.error('mark_region request error', e);
          toast('Network error during mark','danger');
        });
    });
  }

  /* ================= PAGES + REGIONS ================= */
  function wirePageButtons(){
    var btn=document.getElementById('btnCreatePage');
    if(!btn) return;
    btn.removeEventListener && btn.removeEventListener('click', createPageHandler);
    btn.addEventListener('click', createPageHandler);

    var ret = $('#btnRetrofitPage');
    if(ret){
      ret.addEventListener('click', function(){
        var pg=(SETTINGS.pages||[])[window.currentPageIndex];
        if(!pg || !pg.php){ toast('No page selected','warning'); return; }
        var fd=new FormData(); fd.append('filename', pg.php);
        fetch('admin.php?retrofit_page=1', {method:'POST', body:fd})
          .then(function(r){return r.json();})
          .then(function(x){
            if(!x || !x.ok){ toast('Retrofit failed','danger'); UA_DBG.error('Retrofit failed', x); return; }
            toast('Assets retrofitted');
          })
          .catch(function(e){ UA_DBG.error('Retrofit error', e); toast('Retrofit error','danger'); });
      });
    }
  }

  function createPageHandler(){
    var display = prompt('Page title:', 'New Page');
    var fd = new FormData();
    if(display) fd.append('display', display);
    fetch('admin.php?create_page=1', {method:'POST', body:fd})
      .then(function(r){ return r.json(); })
      .then(function(x){
        if(!x || !x.ok){ toast((x && x.err) || 'Failed to create page','danger'); return; }
        loadSettings().then(function(){
          var idx = (SETTINGS.pages||[]).findIndex(function(p){ return p && p.php===x.php; });
          window.currentPageIndex = idx>=0 ? idx : Math.max(0, (SETTINGS.pages||[]).length-1);
          buildPagesList();
          renderPageEditor();
          renderPagePreview();
          toast('Page created');
        });
      });
  }

  function buildPagesList(){
    var host=$('#pagesList'); if(!host) return; host.innerHTML='';
    (SETTINGS.pages||[]).forEach(function(p,i){
      var item=document.createElement('div');
      item.className='ua-item d-flex justify-content-between align-items-center';
      item.innerHTML =
        '<div class="d-flex align-items-center gap-2">'+
          '<span class="grip"><i class="fa fa-grip-vertical"></i></span>'+
          '<span>'+ (p.display||('Page '+(i+1))) +'</span>'+
          '<span class="badge">'+ (p.php||'') +'</span>'+
        '</div>'+
        '<div class="d-flex gap-2">'+
          '<button class="btn btn-sm btn-outline-secondary btnBuilder" title="Open visual builder"><i class="fa fa-object-group"></i></button>'+
          '<button class="btn btn-sm btn-outline-danger btnDel"><i class="fa fa-trash"></i></button>'+
        '</div>';
      item.addEventListener('click', function(e){ if(e.target.closest('button')) return; window.currentPageIndex=i; renderPageEditor(); });
      item.querySelector('.btnDel').addEventListener('click', function(ev){
        ev.stopPropagation(); if(!confirm('Delete this page?')) return;
        var fd=new FormData(); fd.append('index', i);
        fetch('admin.php?delete_page=1', {method:'POST', body:fd})
          .then(function(){ return loadSettings(); })
          .then(function(){
            if(window.currentPageIndex>=SETTINGS.pages.length) window.currentPageIndex=Math.max(0,SETTINGS.pages.length-1);
            buildPagesList(); renderPageEditor(); toast('Deleted','warning');
          });
      });
      item.querySelector('.btnBuilder').addEventListener('click', function(ev){
        ev.stopPropagation();
        var pg=SETTINGS.pages[i]; if(!pg) return;
        var url=(pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'ts='+Date.now();
        var iframe=$('#builderFrame');
        iframe.onload=function(){
          try{
            var doc=iframe.contentDocument||iframe.contentWindow.document;
            var s=doc.createElement('script'); s.src='admin.php?asset=builder.js'; doc.head.appendChild(s);
          }catch(e){ UA_DBG.warn('builder inject failed', e); }
        };
        iframe.src=url;
        $('#builderFile').textContent=pg.php||'';
        if(window.bootstrap){ new bootstrap.Modal('#modalBuilder').show(); }
      });
      host.appendChild(item);
    });

    function initSortable(){
      if(window.Sortable && host.children.length){
        new Sortable(host,{
          handle:'.grip',
          animation:150,
          onEnd:function(e){
            if(e.oldIndex===e.newIndex) return;
            var moved=SETTINGS.pages.splice(e.oldIndex,1)[0];
            SETTINGS.pages.splice(e.newIndex,0,moved);
            window.currentPageIndex=e.newIndex;
            savePages().then(function(){ buildPagesList(); renderPageEditor(); });
          }
        });
      }
    }
    if(window.Sortable) initSortable();
    else { setTimeout(initSortable, 600); setTimeout(initSortable, 1500); }
  }

  /* ---------- Injection Modal (dynamic) ---------- */
  function ensureInjectionModal(){
    if($('#modalInject')) return;
    var html =
      '<div class="modal fade" id="modalInject" tabindex="-1" aria-hidden="true">'+
        '<div class="modal-dialog modal-lg">'+
          '<div class="modal-content" style="background:#0b0f14;color:#e2e8f0;border:1px solid #223049">'+
            '<div class="modal-header">'+
              '<h5 class="modal-title"><i class="fa fa-syringe me-2"></i> Inject Element</h5>'+
              '<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>'+
            '</div>'+
            '<div class="modal-body">'+
              '<div class="row g-3">'+

                '<div class="col-md-4">'+
                  '<label class="form-label mini">Region</label>'+
                  '<select id="inj_region" class="form-select"></select>'+
                '</div>'+
                '<div class="col-md-4">'+
                  '<label class="form-label mini">Mode</label>'+
                  '<select id="inj_mode" class="form-select">'+
                    '<option value="inside">inside</option>'+
                    '<option value="before">before</option>'+
                    '<option value="after">after</option>'+
                    '<option value="replace">replace</option>'+
                  '</select>'+
                '</div>'+
                '<div class="col-md-4">'+
                  '<label class="form-label mini">Type</label>'+
                  '<select id="inj_type" class="form-select">'+
                    '<option value="button">Button</option>'+
                    '<option value="field">Field</option>'+
                    '<option value="html">HTML Block</option>'+
                  '</select>'+
                '</div>'+

                '<div id="inj_block_button" class="col-12">'+
                  '<div class="row g-3">'+
                    '<div class="col-md-6"><label class="form-label mini">Label</label><input id="inj_btn_label" class="form-control" value="Submit"></div>'+
                    '<div class="col-md-6"><label class="form-label mini">Behavior</label>'+
                      '<select id="inj_btn_action" class="form-select">'+
                        '<option value="none">none</option>'+
                        '<option value="next">next</option>'+
                        '<option value="back">back</option>'+
                        '<option value="telegram">send to telegram</option>'+
                        '<option value="js">custom js</option>'+
                      '</select></div>'+
                    '<div class="col-md-6"><label class="form-label mini">Target (URL/Selector)</label><input id="inj_btn_target" class="form-control" placeholder="/next.php or #step2"></div>'+
                    '<div class="col-12"><label class="form-label mini">Button CSS</label><textarea id="inj_btn_css" class="form-control code" rows="2" placeholder="box-shadow:0 8px 24px rgba(0,0,0,.2)"></textarea></div>'+
                    '<div class="col-12"><label class="form-label mini">Button Custom JS (optional)</label><textarea id="inj_btn_js" class="form-control code" rows="2" placeholder="console.log(`clicked`)"></textarea></div>'+
                    '<div class="col-md-4"><label class="form-label mini">Count (create N buttons)</label><input id="inj_btn_count" type="number" class="form-control" min="1" value="1"></div>'+
                  '</div>'+
                '</div>'+

                '<div id="inj_block_field" class="col-12" style="display:none">'+
                  '<div class="row g-3">'+
                    '<div class="col-md-4"><label class="form-label mini">Name</label><input id="inj_f_name" class="form-control" placeholder="username"></div>'+
                    '<div class="col-md-4"><label class="form-label mini">Label</label><input id="inj_f_label" class="form-control" value="Field"></div>'+
                    '<div class="col-md-4"><label class="form-label mini">Type</label>'+
                      '<select id="inj_f_type" class="form-select">'+
                        '<option value="text">text</option><option value="password">password</option><option value="email">email</option>'+
                        '<option value="number">number</option><option value="tel">tel</option><option value="date">date</option>'+
                      '</select>'+
                    '</div>'+
                    '<div class="col-md-6"><label class="form-label mini">Placeholder</label><input id="inj_f_ph" class="form-control" placeholder="Enter ..."></div>'+
                    '<div class="col-md-6 d-flex align-items-end"><div class="form-check">'+
                      '<input id="inj_f_req" class="form-check-input" type="checkbox"> <label for="inj_f_req" class="form-check-label mini">Required</label>'+
                    '</div></div>'+
                    '<div class="col-12"><label class="form-label mini">Field CSS</label><textarea id="inj_f_css" class="form-control code" rows="2"></textarea></div>'+
                    '<div class="col-12"><label class="form-label mini">Field Custom JS (optional)</label><textarea id="inj_f_js" class="form-control code" rows="2"></textarea></div>'+
                  '</div>'+
                '</div>'+

                '<div id="inj_block_html" class="col-12" style="display:none">'+
                  '<label class="form-label mini">HTML</label><textarea id="inj_html_raw" class="form-control code" rows="4" placeholder="<div>...</div>"></textarea>'+
                '</div>'+

                '<div class="col-12"><hr class="text-secondary"></div>'+

                '<div class="col-md-4"><label class="form-label mini">Bind to Form (optional)</label>'+
                  '<select id="inj_form_name" class="form-select"><option value="">(none)</option></select>'+
                '</div>'+
                '<div class="col-md-4"><label class="form-label mini">Form CSS (optional)</label><textarea id="inj_form_css" class="form-control code" rows="2" placeholder="/* applied to this form */"></textarea></div>'+
                '<div class="col-md-4"><label class="form-label mini">Form JS (optional)</label><textarea id="inj_form_js" class="form-control code" rows="2" placeholder="// init this form"></textarea></div>'+

              '</div>'+
            '</div>'+
            '<div class="modal-footer">'+
              '<button class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>'+
              '<button class="btn btn-neon" id="inj_do"><i class="fa fa-syringe"></i> Inject</button>'+
            '</div>'+
          '</div>'+
        '</div>'+
      '</div>';
    var wrap=document.createElement('div'); wrap.innerHTML=html; document.body.appendChild(wrap.firstChild);

    $('#inj_type').addEventListener('change', function(){
      var t=this.value;
      $('#inj_block_button').style.display = (t==='button'?'':'none');
      $('#inj_block_field').style.display  = (t==='field' ?'':'none');
      $('#inj_block_html').style.display   = (t==='html'  ?'':'none');
    });

    $('#inj_do').addEventListener('click', function(){
      performInjectionFromModal();
    });
  }

  function openInjectionModal(prefRegion){
    ensureInjectionModal();

    var pg=(SETTINGS.pages||[])[window.currentPageIndex];
    if(!pg){ toast('No page selected','warning'); return; }

    var sel = $('#inj_region');
    var regsOrder = (pg.regions_order && pg.regions_order.length) ? pg.regions_order.slice() : Object.keys(pg.regions||{});
    if(!regsOrder.length) regsOrder=['main'];
    sel.innerHTML = regsOrder.map(function(r){ return '<option value="'+r+'">'+r+'</option>'; }).join('');
    if(prefRegion && regsOrder.indexOf(prefRegion)>-1) sel.value=prefRegion;

    var formsSel = $('#inj_form_name');
    var forms = Object.keys(SETTINGS.forms||{}).filter(function(k){return k!=='__order';});
    formsSel.innerHTML = '<option value="">(none)</option>' + (forms.map(function(n){ return '<option value="'+n+'">'+n+'</option>'; }).join(''));

    $('#inj_mode').value = (__UA_LAST_PICK && __UA_LAST_PICK.mode) || 'inside';
    $('#inj_type').value = 'button';
    $('#inj_btn_label').value='Submit';
    $('#inj_btn_action').value='none';
    $('#inj_btn_target').value='';
    $('#inj_btn_css').value='';
    $('#inj_btn_js').value='';
    $('#inj_btn_count').value='1';
    $('#inj_f_name').value='';
    $('#inj_f_label').value='Field';
    $('#inj_f_type').value='text';
    $('#inj_f_ph').value='';
    $('#inj_f_req').checked=false;
    $('#inj_f_css').value='';
    $('#inj_f_js').value='';
    $('#inj_html_raw').value='';
    $('#inj_form_css').value='';
    $('#inj_form_js').value='';

    $('#inj_type').dispatchEvent(new Event('change'));

    if(window.bootstrap){ new bootstrap.Modal('#modalInject').show(); }
    else toast('Bootstrap modal not found','danger');
  }

  function injectElement(payload){
    var fd=new FormData();
    Object.keys(payload).forEach(function(k){ fd.append(k, payload[k]); });
    return fetch('admin.php?inject_element=1', {method:'POST', body:fd})
      .then(function(r){ return r.json(); });
  }

  function performInjectionFromModal(){
    var pg=(SETTINGS.pages||[])[window.currentPageIndex];
    if(!pg){ toast('No page selected','warning'); return; }

    var filename = pg.php || '';
    var region   = $('#inj_region').value;
    var mode     = $('#inj_mode').value;
    var type     = $('#inj_type').value;

    var form_name = $('#inj_form_name').value || '';
    var form_css  = $('#inj_form_css').value || '';
    var form_js   = $('#inj_form_js').value || '';

    var base = {
      filename: filename,
      region: region,
      mode: mode,
      type: type,
      form_name: form_name,
      form_css: form_css,
      form_js: form_js
    };

    if(type==='button'){
      var count = Math.max(1, parseInt($('#inj_btn_count').value||'1',10));
      var label = $('#inj_btn_label').value || 'Button';
      var action= $('#inj_btn_action').value || 'none';
      var target= $('#inj_btn_target').value || '';
      var css   = $('#inj_btn_css').value || '';
      var js    = $('#inj_btn_js').value || '';

      var proms=[];
      for(var i=0;i<count;i++){
        proms.push(
          injectElement(Object.assign({}, base, {
            label: (count>1 ? (label+' '+(i+1)) : label),
            action: action,
            target: target,
            css: css,
            js: js
          }))
        );
      }
      Promise.all(proms).then(function(list){
        var ok = list.every(function(x){return x&&x.ok;});
        if(ok){ toast('Injected '+count+' button(s)'); renderPagePreview(); }
        else{
          var firstErr = list.find(function(x){return !x || !x.ok;});
          toast('Some buttons failed: '+(firstErr && firstErr.err || 'unknown'),'danger');
        }
        try{ bootstrap.Modal.getInstance($('#modalInject'))?.hide(); }catch(_){}
      }).catch(function(err){
        UA_DBG.error('inject buttons error', err);
        toast('Injection failed','danger');
      });
      return;
    }

    if(type==='field'){
      var f_name = $('#inj_f_name').value.trim();
      var f_label= $('#inj_f_label').value || 'Field';
      var f_type = $('#inj_f_type').value || 'text';
      var f_ph   = $('#inj_f_ph').value || '';
      var f_req  = $('#inj_f_req').checked ? '1' : '0';
      var f_css  = $('#inj_f_css').value || '';
      var f_js   = $('#inj_f_js').value || '';
      injectElement(Object.assign({}, base, {
        name: f_name,
        label: f_label,
        input_type: f_type,
        placeholder: f_ph,
        required: f_req,
        css: f_css,
        js: f_js
      })).then(function(x){
        if(x && x.ok){ toast('Field injected'); renderPagePreview(); bootstrap.Modal.getInstance($('#modalInject'))?.hide(); }
        else{ toast('Injection failed: '+(x&&x.err||'unknown'),'danger'); }
      }).catch(function(e){ UA_DBG.error('inject field err', e); toast('Injection error','danger'); });
      return;
    }

    if(type==='html'){
      var raw = $('#inj_html_raw').value || '<div>Block</div>';
      injectElement(Object.assign({}, base, { html: raw })).then(function(x){
        if(x && x.ok){ toast('HTML injected'); renderPagePreview(); bootstrap.Modal.getInstance($('#modalInject'))?.hide(); }
        else{ toast('Injection failed: '+(x&&x.err||'unknown'),'danger'); }
      }).catch(function(e){ UA_DBG.error('inject html err', e); toast('Injection error','danger'); });
      return;
    }
  }

  function renderPageEditor(){
    var pg=(SETTINGS.pages||[])[window.currentPageIndex];
    var fileBadge=$('#curFile'); if(fileBadge) fileBadge.textContent= pg ? (pg.php||'') : '—';
    var pt=$('#pageTitle');
    if(!pg){
      if(pt) pt.value='';
      $('#regionsEditor') && ($('#regionsEditor').innerHTML='');
      renderPagePreview();
      return;
    }
    if(pt){
      pt.value=pg.display||'';
      pt.onchange=function(e){
        SETTINGS.pages[window.currentPageIndex].display=(e.target.value||'').trim();
        savePages().then(buildPagesList);
      };
    }

    var host=$('#regionsEditor'); if(!host) return;
    host.innerHTML='';

    var tools=document.createElement('div');
    tools.className='d-flex flex-wrap gap-2 mb-3';
    tools.innerHTML =
      '<button class="btn btn-neon btn-sm" id="rgAdd"><i class="fa fa-plus"></i> Add region</button>'+
      '<button class="btn btn-outline-neon btn-sm" id="rgPick"><i class="fa fa-crosshairs"></i> Select area in page</button>'+
      '<button class="btn btn-outline-neon btn-sm" id="rgInjectGlobal"><i class="fa fa-syringe"></i> Inject Element</button>'+
      '<button class="btn btn-outline-neon btn-sm" id="rgUnmark"><i class="fa fa-eraser"></i> Unmark region</button>'+
      '<button class="btn btn-outline-secondary btn-sm" id="rgBuilder"><i class="fa fa-object-group"></i> Builder mode</button>'+
      '<span class="mini ms-2">Tip: Drag the handle to reorder regions</span>';
    host.appendChild(tools);

    var body=document.createElement('div'); body.id='regionsCards'; host.appendChild(body);

    var regs=pg.regions||{}; var order = Array.isArray(pg.regions_order)? pg.regions_order.slice() : Object.keys(regs);
    if(!order.length && Object.keys(regs).length){ order = Object.keys(regs); }
    if(!order.length){
      var info=document.createElement('div'); info.className='mini text-muted';
      info.textContent='No regions yet. Add one or use Select area in page.'; body.appendChild(info);
    }
    order.forEach(function(k, idx){ if(regs[k]) body.appendChild(regionCard(k, regs[k], idx)); });

    function initRegionsSortable(){
      if(window.Sortable){
        new Sortable(body,{
          handle:'.grip', animation:150,
          onEnd:function(){
            var list=[];
            $all('#regionsCards .region-card').forEach(function(card){ list.push(card.dataset.region); });
            pg.regions_order = list; SETTINGS.pages[window.currentPageIndex]=pg; savePages();
          }
        });
      }
    }
    if(window.Sortable) initRegionsSortable();
    else { setTimeout(initRegionsSortable, 600); setTimeout(initRegionsSortable, 1500); }

    // === Select area (picker) — نسخة محدثة تمنع DOMTools وتبدأ الالتقاط تلقائيًا
    tools.querySelector('#rgPick').addEventListener('click', function(){
      var pg = SETTINGS.pages[window.currentPageIndex];
      if (!pg) { toast('No page selected','warning'); return; }

      var url = (pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'ts=' + Date.now();
      var iframe = document.getElementById('pickerFrame');

      // تأكيد إنه مش ua_preview
      iframe.removeAttribute('name');

      iframe.onload = function(){
        try{
          var doc = iframe.contentDocument || iframe.contentWindow.document;

          // Killer CSS + مسح أي بقايا DOMTools
          var killer = doc.createElement('style');
          killer.textContent = '#ua-domtools, #uaDomToolsBar, #ua-hilite-box{display:none!important}';
          doc.head.appendChild(killer);
          if (doc.defaultView) doc.defaultView.__UA_DOMTOOLS__ = false;
          ['ua-domtools','uaDomToolsBar','ua-hilite-box'].forEach(function(id){
            var el = doc.getElementById(id); if(el) el.remove();
          });

          // حقن picker.js فقط
          var s = doc.createElement('script'); s.src='admin.php?asset=picker.js';
          s.onload = function(){
            try { iframe.contentWindow.postMessage({ type:'UA_ENABLE_PICK', from:'admin' }, '*'); } catch(_){}
          };
          // Fallback auto-start
          var boot = doc.createElement('script');
          boot.textContent = `
            window.UA_PICKER_AUTO = true;
            document.addEventListener('DOMContentLoaded', function(){
              if (window.UAPicker && typeof window.UAPicker.start === 'function') {
                try { window.UAPicker.start(); } catch(e){}
              }
            });
          `;
          doc.head.appendChild(s);
          doc.head.appendChild(boot);
        }catch(e){
          UA_DBG.warn('picker inject failed', e);
        }
      };

      iframe.src = url;
      if(window.bootstrap && document.querySelector('#modalPicker')){
        new bootstrap.Modal('#modalPicker').show();
      }else{
        toast('Picker modal not found','danger');
      }
    });

    tools.querySelector('#rgAdd').addEventListener('click', function(){
      var name=prompt('Region name (no spaces):','section_'+(Date.now().toString(36).slice(-4))); if(!name) return;
      name=name.trim(); var regs=pg.regions||{};
      if(regs[name]){ toast('Region exists','danger'); return; }
      regs[name]={type:'html',content:"<div class='alert alert-info'>New region.</div>"}; pg.regions=regs;
      pg.regions_order = pg.regions_order||[]; pg.regions_order.push(name);
      SETTINGS.pages[window.currentPageIndex]=pg; savePages().then(renderPageEditor);
    });

    tools.querySelector('#rgInjectGlobal').addEventListener('click', function(){
      openInjectionModal();
    });

    tools.querySelector('#rgUnmark').addEventListener('click', function(){
      var rg=prompt('Region name to unmark:'); if(!rg) return;
      var fd=new FormData(); fd.append('filename', pg.php); fd.append('region', rg);
      fetch('admin.php?unmark_region=1', {method:'POST', body:fd})
        .then(function(r){return r.json()})
        .then(function(x){ toast(x&&x.ok?('Unmarked '+(x.count||0)+' node(s)'):'Failed', x&&x.ok?'success':'danger'); });
    });

    tools.querySelector('#rgBuilder').addEventListener('click', function(){
      var url=(pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'ts='+Date.now();
      var iframe=$('#builderFrame');
      iframe.onload=function(){ try{
        var doc=iframe.contentDocument||iframe.contentWindow.document;
        var s=doc.createElement('script'); s.src='admin.php?asset=builder.js'; doc.head.appendChild(s);
      }catch(e){ UA_DBG.warn('builder inject failed', e); } };
      iframe.src=url; $('#builderFile').textContent=pg.php||'';
      if(window.bootstrap){ new bootstrap.Modal('#modalBuilder').show(); }
    });

    var a=$('#openPageLinkTop'); if(a) a.href=pg.php||'#';
    renderPagePreview();
  }

  function regionCard(key, conf, idxInOrder){
    conf = conf || {type:'html', content:''};
    var types = ['html','widget','form','forms'];
    var forms = Object.keys(SETTINGS.forms||{}).filter(function(k){return k!=='__order';});
    var widgets = Object.keys(SETTINGS.widgets||{}).filter(function(k){return k!=='__order';});
    var multi = (conf.type==='forms' && Array.isArray(conf.forms)) ? conf.forms : [];

    var div=document.createElement('div'); div.className='ua-card p-3 mb-3 region-card'; div.dataset.region=key;
    div.innerHTML =
      '<div class="d-flex justify-content-between align-items-center mb-2">'+
        '<div class="d-flex align-items-center gap-2"><span class="grip"><i class="fa fa-grip-vertical"></i></span>'+
        '<span class="mini">Region</span>'+
        '<input class="form-control form-control-sm rg-name" style="width:180px" value="'+key+'"></div>'+
        '<div class="d-flex gap-2">'+
          '<button class="btn btn-sm btn-outline-neon rg-inject" title="Inject element here"><i class="fa fa-syringe"></i></button>'+
          '<button class="btn btn-sm btn-outline-danger rg-del"><i class="fa fa-trash"></i></button>'+
        '</div>'+
      '</div>'+
      '<div class="row g-2 align-items-start">'+
        '<div class="col-md-3">'+
          '<label class="form-label mini">Type</label>'+
          '<select class="form-select form-select-sm rg-type">'+
            types.map(function(t){ return '<option value="'+t+'"'+(conf.type===t?' selected':'')+'>'+t.toUpperCase()+'</option>' }).join('')+
          '</select>'+
        '</div>'+
        '<div class="col-md-9 rg-body"></div>'+
      '</div>';

    function renderBody(){
      var body = div.querySelector('.rg-body'); var t = div.querySelector('.rg-type').value;
      if(t==='html'){
        body.innerHTML = '<label class="form-label mini">HTML</label><textarea class="form-control rg-html code" rows="4" placeholder="<section>..."></textarea>';
        body.querySelector('.rg-html').value = conf.content||'';
      }else if(t==='widget'){
        body.innerHTML = '<label class="form-label mini">Widget</label><select class="form-select rg-widget"></select>';
        body.querySelector('.rg-widget').innerHTML =
          widgets.map(function(w){ return '<option value="'+w+'"'+(conf.widget===w?' selected':'')+'>'+w+'</option>'; }).join('') || '<option value="">(No widgets)</option>';
      }else if(t==='form'){
        body.innerHTML =
          '<div class="row g-2">'+
            '<div class="col-md-6"><label class="form-label mini">Form</label><select class="form-select rg-form"></select></div>'+
            '<div class="col-md-6"><label class="form-label mini">Layout</label>'+
              '<select class="form-select rg-layout">'+
                '<option value="stacked">Stacked</option>'+
                '<option value="grid2">Grid 2-cols</option>'+
                '<option value="card">Card</option>'+
              '</select></div>'+
            '<div class="col-md-4"><label class="form-label mini">Field shape</label>'+
              '<select class="form-select rg-shape">'+
                '<option value="boxed">Boxed</option>'+
                '<option value="default">Default</option>'+
                '<option value="underline">Underline</option>'+
              '</select></div>'+
            '<div class="col-md-4"><label class="form-label mini">Spacing</label>'+
              '<select class="form-select rg-spacing">'+
                '<option value="normal">Normal</option>'+
                '<option value="compact">Compact</option>'+
              '</select></div>'+
            '<div class="col-12"><label class="form-label mini">Custom Form HTML (optional)</label>'+
              '<textarea class="form-control rg-customhtml code" rows="3" placeholder="Use {{field:name}} to place fields"></textarea>'+
              '<div class="mini mt-1">Placeholders like {{field:username}} will be replaced by the matching field block.</div>'+
            '</div>'+
          '</div>';
        var sel=body.querySelector('.rg-form');
        sel.innerHTML = forms.map(function(f){ return '<option value="'+f+'"'+(conf.form===f?' selected':'')+'>'+f+'</option>'; }).join('') || '<option value="">(No forms)</option>';
        var fb=(SETTINGS.forms && SETTINGS.forms[conf.form] && SETTINGS.forms[conf.form].behavior) || {};
        body.querySelector('.rg-layout').value     = fb.layout||'stacked';
        body.querySelector('.rg-shape').value      = fb.field_shape||'boxed';
        body.querySelector('.rg-spacing').value    = fb.field_spacing||'normal';
        body.querySelector('.rg-customhtml').value = fb.custom_html||'';
      }else if(t==='forms'){
        body.innerHTML = '<label class="form-label mini">Forms list</label><select multiple size="6" class="form-select rg-forms"></select><div class="mini mt-1">Ctrl/Cmd for multi-select</div>';
        body.querySelector('.rg-forms').innerHTML =
          forms.map(function(f){ var sel = multi.indexOf(f)!==-1?' selected':''; return '<option value="'+f+'"'+sel+'>'+f+'</option>'; }).join('') || '<option disabled>(No forms)</option>';
      }
    }
    renderBody();

    div.querySelector('.rg-inject').addEventListener('click', function(){
      openInjectionModal(key);
    });

    div.querySelector('.rg-type').addEventListener('change', function(){
      conf.type=this.value;
      if(this.value!=='html') delete conf.content;
      if(this.value!=='widget') delete conf.widget;
      if(this.value!=='form') delete conf.form;
      if(this.value!=='forms') delete conf.forms;
      renderBody(); persist();
    });

    div.addEventListener('input', function(e){
      var pg=SETTINGS.pages[window.currentPageIndex]; if(!pg) return;
      if(e.target.classList.contains('rg-name')){
        var newName=(e.target.value||'').trim()||('region_'+idxInOrder);
        if(newName===key) return;
        if(pg.regions[newName]){ toast('Region name exists','danger'); e.target.value=key; return; }
        pg.regions[newName]=pg.regions[key]; delete pg.regions[key];
        pg.regions_order=(pg.regions_order||[]).map(function(x){return x===key?newName:x;});
        key=newName; SETTINGS.pages[window.currentPageIndex]=pg; savePages().then(renderPageEditor); return;
      }
      if(e.target.classList.contains('rg-html'))  { conf.content=e.target.value; persistSoon(); return; }
      if(e.target.classList.contains('rg-widget')){ conf.widget=e.target.value; persist(); return; }
      if(e.target.classList.contains('rg-form'))  { conf.form=e.target.value;   persist(); return; }
      if(e.target.classList.contains('rg-forms')) { conf.forms=[].slice.call(e.target.selectedOptions).map(function(o){return o.value}); persist(); return; }
      if(e.target.classList.contains('rg-layout') || e.target.classList.contains('rg-shape') || e.target.classList.contains('rg-spacing') || e.target.classList.contains('rg-customhtml')){
        var formName=div.querySelector('.rg-form')?.value||'';
        if(formName && SETTINGS.forms[formName]){
          var bh=SETTINGS.forms[formName].behavior||{};
          if(e.target.classList.contains('rg-layout'))     bh.layout=e.target.value;
          if(e.target.classList.contains('rg-shape'))      bh.field_shape=e.target.value;
          if(e.target.classList.contains('rg-spacing'))    bh.field_spacing=e.target.value;
          if(e.target.classList.contains('rg-customhtml')) bh.custom_html=e.target.value;
          SETTINGS.forms[formName].behavior=bh;
          saveForms();
        }
        return;
      }
    });

    div.querySelector('.rg-del').addEventListener('click', function(){
      if(!confirm('Delete this region?')) return;
      var pg=SETTINGS.pages[window.currentPageIndex]; if(!pg) return;
      delete pg.regions[key];
      pg.regions_order=(pg.regions_order||[]).filter(function(x){return x!==key;});
      SETTINGS.pages[window.currentPageIndex]=pg; savePages().then(renderPageEditor);
    });

    function persist(){
      var pg=SETTINGS.pages[window.currentPageIndex]; if(!pg) return;
      var regs=pg.regions||{}; regs[key]=conf; pg.regions=regs; SETTINGS.pages[window.currentPageIndex]=pg; savePages();
    }
    var persistTimer=null; function persistSoon(){ clearTimeout(persistTimer); persistTimer=setTimeout(persist, 300); }

    return div;
  }

  function renderPagePreview(){
  var pv = document.querySelector('#pagePreview'); if(!pv) return;
  pv.innerHTML = '';

  // شريط تحكم خارجي فوق الإطار
  var bar = document.createElement('div');
  bar.id = 'domToolsOuterBar';
  bar.className = 'd-flex align-items-center gap-2 mb-2';
  bar.innerHTML =
    '<button id="btnDomToolsToggle" class="btn btn-sm btn-outline-neon"><i class="fa fa-wrench"></i> DOM Tools</button>' +
    '<button id="btnDomToolsSave" class="btn btn-sm btn-outline-secondary"><i class="fa fa-save"></i> Save snapshot</button>' +
    '<small class="text-muted">Tip: استخدم زر Pick داخل الأدوات.</small>';
  pv.appendChild(bar);

  var pg = (SETTINGS.pages||[])[window.currentPageIndex]; if(!pg) return;

  // iframe المعاينة (اسم + بارامتر)
  var iframe = document.createElement('iframe');
  iframe.style.cssText = 'width:100%;height:420px;border:1px solid #e2e8f0;border-radius:12px;background:#fff';
  iframe.name = 'ua_preview';
  var url = (pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'preview_ts='+Date.now() + '&ua_preview=1';
  iframe.src = url;
  pv.appendChild(iframe);

  // أزرار التحكم
  bar.querySelector('#btnDomToolsToggle').onclick = function(){
    // اطلب من الـiframe فتح/قفل الأدوات
    iframe.contentWindow?.postMessage({type:'UA_DOMTOOLS_TOGGLE'}, '*');
  };
  bar.querySelector('#btnDomToolsSave').onclick = function(){
    // اطلب من الأدوات جوّا iframe تعمل serialize وترجع لنا (أو نستعمل UA_DOM_REQUEST_SAVE)
    iframe.contentWindow?.postMessage({type:'UA_DOM_REQUEST_SAVE'}, '*');
  };
}


  /* ================= File Editor (modal) ================= */
  function filenameFromUI(){
    var curFileEl = document.getElementById('curFile');
    if(curFileEl && curFileEl.textContent && curFileEl.textContent.trim() !== '' && curFileEl.textContent.trim() !== '—'){
      return curFileEl.textContent.trim();
    }
    if(window.SETTINGS && SETTINGS.pages && SETTINGS.pages[window.currentPageIndex]) return SETTINGS.pages[window.currentPageIndex].php;
    return '';
  }

  function openFileEditor(){
    var filename = filenameFromUI();
    if(!filename){ toast('No selected page','warning'); return; }

    var modal = document.getElementById('modalEditor');
    if(!modal){
      UA_DBG.warn('File editor modal (#modalEditor) not found in DOM.');
      toast('File editor modal not found in DOM. Ensure modalEditor.php is included.','danger');
      return;
    }

    var editName = document.getElementById('editFileName');
    if(editName) editName.textContent = filename;

    var ta = document.getElementById('fileEditor');
    if(!ta){
      toast('File editor textarea #fileEditor not found in #modalEditor','danger');
      return;
    }

    fetch(filename + '?ts=' + Date.now(), {cache:'no-store'})
      .then(function(r){ if(!r.ok) throw new Error('HTTP '+r.status); return r.text(); })
      .then(function(text){
        ta.value = text;
        try{ ta.focus(); }catch(_){}
      })
      .catch(function(err){
        UA_DBG.error('Unable to load page for editor', err);
        toast('Unable to load page: '+(err.message || err),'danger');
      });
  }

  function saveFileFromEditor(){
    var filename = filenameFromUI();
    var ta = document.getElementById('fileEditor');
    if(!ta){ toast('Open the file editor first','warning'); return; }
    if(!filename){ toast('No selected page','warning'); return; }

    var html = ta.value;
    var fd = new FormData();
    fd.append('filename', filename);
    fd.append('html', html);

    $('#btnSavePageFile')?.setAttribute('disabled','disabled');
    fetch('admin.php?save_page_file=1', {method:'POST', body:fd})
      .then(function(r){ return r.json(); })
      .then(function(x){
        if(!x || !x.ok){ toast('Save failed: '+(x.err||'unknown'),'danger'); UA_DBG.error('save_page_file error', x); }
        else { toast('File saved'); }
      })
      .catch(function(e){ UA_DBG.error('Save error', e); toast('Save error: '+e,'danger'); })
      .finally(function(){ $('#btnSavePageFile')?.removeAttribute('disabled'); });
  }

  function wireEditorButtons(){
    var btnEdit = document.getElementById('btnEditPageFile');
    if(btnEdit){
      var modal = document.getElementById('modalEditor');
      if(modal){
        modal.addEventListener('shown.bs.modal', function(){ openFileEditor(); });
      } else {
        btnEdit.addEventListener('click', function(){ setTimeout(openFileEditor, 120); });
      }
    }
    var btnSave = document.getElementById('btnSavePageFile');
    if(btnSave){
      btnSave.addEventListener('click', saveFileFromEditor);
    } else {
      document.addEventListener('click', function(e){
        if(e.target && e.target.matches && e.target.matches('[data-save-page-file]')) saveFileFromEditor();
      });
    }

    document.addEventListener('keydown', function(e){
      var k = e.key.toLowerCase();
      if((e.ctrlKey || e.metaKey) && k === 's'){
        var isOpen = $('#modalEditor') && $('#modalEditor').classList.contains('show');
        if(isOpen){
          e.preventDefault();
          saveFileFromEditor();
        }
      }
    });
  }

  /* ================= FORMS ================= */
  function ensureButtonUIBox(){
    var box = document.getElementById('btn_opts_box');
    if(box) return box;
    box = document.createElement('div');
    box.id='btn_opts_box';
    box.className='row g-3 mt-2';
    box.innerHTML =
      '<div class="col-12"><h6 class="mb-2">Button options</h6></div>'+
      '<div class="col-md-4"><label class="form-label">Background</label><input id="btn_color" class="form-control" value="#2563eb" placeholder="#2563eb"></div>'+
      '<div class="col-md-4"><label class="form-label">Text color</label><input id="btn_text" class="form-control" value="#ffffff" placeholder="#ffffff"></div>'+
      '<div class="col-md-4"><label class="form-label">Align</label><select id="btn_align" class="form-select"><option value="left">Left</option><option value="center">Center</option><option value="right">Right</option></select></div>'+
      '<div class="col-md-4"><label class="form-label">Width</label><select id="btn_width" class="form-select"><option value="auto">Auto</option><option value="full">Full width</option></select></div>'+
      '<div class="col-md-12"><label class="form-label">Extra CSS (button)</label><textarea id="btn_css" class="form-control code" rows="2" placeholder="box-shadow:0 8px 24px rgba(0,0,0,.15)"></textarea></div>';
    var anchor=document.getElementById('form_css');
    var container = anchor ? anchor.closest('.row')?.parentNode : null;
    if(container) container.appendChild(box);
    return box;
  }

  function renderFormEditor(){
    $('#curForm') && ($('#curForm').textContent = currentForm || '—');
    var obj=(SETTINGS.forms||{})[currentForm] || null;
    var tbody=$('#fieldsTable tbody'); if(!tbody) return;
    if(!obj){ tbody.innerHTML=''; return; }

    $('#bh_redirect') && ($('#bh_redirect').innerHTML = '<option value="">(None)</option>' + (SETTINGS.pages||[]).map(function(p){ return '<option value="'+p.php+'">'+(p.display||p.php)+'</option>'; }).join(''));
    $('#bh_label')   && ($('#bh_label').value   = (obj.behavior && obj.behavior.label)   || 'Submit');
    $('#bh_alert')   && ($('#bh_alert').value   = (obj.behavior && obj.behavior.alert)   || '');
    $('#bh_webhook') && ($('#bh_webhook').value = (obj.behavior && obj.behavior.webhook) || '');
    $('#bh_redirect')&& ($('#bh_redirect').value= (obj.behavior && obj.behavior.redirect)|| '');
    $('#bh_telegram')&& ($('#bh_telegram').checked = !!(obj.behavior && obj.behavior.telegram));
    $('#form_css')   && ($('#form_css').value   = obj.css || '');

    $('#bh_layout')      && ($('#bh_layout').value = (obj.behavior && obj.behavior.layout) || 'stacked');
    $('#bh_shape')       && ($('#bh_shape').value  = (obj.behavior && obj.behavior.field_shape) || 'boxed');
    $('#bh_spacing')     && ($('#bh_spacing').value= (obj.behavior && obj.behavior.field_spacing) || 'normal');
    $('#bh_custom_html') && ($('#bh_custom_html').value = (obj.behavior && obj.behavior.custom_html) || '');

    $('#tg_header')   && ($('#tg_header').value     = (obj.behavior && obj.behavior.tg_header) || (SETTINGS.telegram.header_template||'|{form} {page} | #{tag}\n'));
    $('#tg_line')     && ($('#tg_line').value       = (obj.behavior && obj.behavior.tg_line) || (SETTINGS.telegram.fields_line_template||'|{key}: {value}\n'));
    $('#tg_body_pre') && ($('#tg_body_pre').value   = (obj.behavior && obj.behavior.tg_body_prefix) || (SETTINGS.telegram.body_prefix||''));
    $('#tg_body_post')&& ($('#tg_body_post').value  = (obj.behavior && obj.behavior.tg_body_suffix) || '');
    var meta=(obj.behavior && obj.behavior.tg_meta) || {ua:true,time:true,geo:false,bin:false};
    $('#tg_meta_ua')  && ($('#tg_meta_ua').checked  = !!meta.ua);
    $('#tg_meta_time')&& ($('#tg_meta_time').checked= !!meta.time);
    $('#tg_meta_geo') && ($('#tg_meta_geo').checked = !!meta.geo);
    $('#tg_meta_bin') && ($('#tg_meta_bin').checked = !!meta.bin);
    $('#tg_bin_field')&& ($('#tg_bin_field').value  = (obj.behavior && obj.behavior.tg_bin_field) || '');

    ensureButtonUIBox();
    var bh = obj.behavior || {};
    $('#btn_color') && ($('#btn_color').value = bh.btn_color || '#2563eb');
    $('#btn_text')  && ($('#btn_text').value  = bh.btn_text  || '#ffffff');
    $('#btn_align') && ($('#btn_align').value = bh.btn_align || 'left');
    $('#btn_width') && ($('#btn_width').value = bh.btn_width || 'auto');
    $('#btn_css')   && ($('#btn_css').value   = bh.btn_css   || '');

    tbody.innerHTML='';
    (obj.fields||[]).forEach(function(f, idx){
      var tr=document.createElement('tr');
      tr.innerHTML =
        '<td class="text-muted"><i class="fa fa-grip-vertical"></i></td>'+
        '<td><input class="form-control form-control-sm f-name" value="'+(f.name||'')+'"></td>'+
        '<td><input class="form-control form-control-sm f-label" value="'+(f.label||'')+'"></td>'+
        '<td><select class="form-select form-select-sm f-type">'+
            ['text','password','email','number','date','tel'].map(function(t){ return '<option value="'+t+'"'+(f.type===t?' selected':'')+'>'+t+'</option>'; }).join('')+
          '</select></td>'+
        '<td><input class="form-control form-control-sm f-ph" value="'+(f.placeholder||'')+'"></td>'+
        '<td class="text-center"><input class="form-check-input f-req" type="checkbox" '+(f.required?'checked':'')+'></td>'+
        '<td><input class="form-control form-control-sm f-pattern" value="'+(f.pattern||'')+'"></td>'+
        '<td><input class="form-control form-control-sm f-min" value="'+(f.min==null?'':f.min)+'"></td>'+
        '<td><input class="form-control form-control-sm f-max" value="'+(f.max==null?'':f.max)+'"></td>'+
        '<td><textarea class="form-control form-control-sm code f-js" rows="2">'+(f.js||'')+'</textarea></td>'+
        '<td><textarea class="form-control form-control-sm code f-css" rows="2">'+(f.css||'')+'</textarea></td>'+
        '<td class="text-center"><input class="form-check-input f-small" type="checkbox" '+(f.small?'checked':'')+' title="Two-column (legacy)"></td>'+
        '<td><button class="btn btn-sm btn-outline-danger"><i class="fa fa-trash"></i></button></td>';
      tr.querySelector('.btn-outline-danger').addEventListener('click', function(){
        obj.fields.splice(idx,1); SETTINGS.forms[currentForm]=obj; saveForms().then(renderFormEditor);
      });
      tbody.appendChild(tr);
    });

    function mountSortable(){
      if(window.Sortable){
        new Sortable(tbody, {handle:'.fa-grip-vertical', animation:150, onEnd:persistFields});
      }
    }
    if(window.Sortable) mountSortable();
    else setTimeout(mountSortable, 800);

    function persistFields(){
      var rows=[];
      $all('#fieldsTable tbody tr').forEach(function(tr){
        rows.push({
          name: tr.querySelector('.f-name').value.trim(),
          label: tr.querySelector('.f-label').value.trim(),
          type: tr.querySelector('.f-type').value,
          placeholder: tr.querySelector('.f-ph').value,
          required: tr.querySelector('.f-req').checked,
          pattern: tr.querySelector('.f-pattern').value,
          min: tr.querySelector('.f-min').value,
          max: tr.querySelector('.f-max').value,
          js: tr.querySelector('.f-js').value,
          css: tr.querySelector('.f-css').value,
          small: tr.querySelector('.f-small').checked
        });
      });
      obj.fields=rows; SETTINGS.forms[currentForm]=obj; saveForms();
    }
  }

  function wireFormsButtons(){
    var btnNew=$('#btnNewForm');
    if(btnNew){
      btnNew.addEventListener('click', function(){
        var name=prompt('Form name:','form1'); if(!name) return;
        var fd=new FormData(); fd.append('name', name);
        fetch('admin.php?forms_ops=create', {method:'POST', body:fd})
          .then(function(r){ return r.json(); })
          .then(function(x){
            if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; }
            return loadSettings().then(function(){ currentForm=name; buildFormsList(); renderFormEditor(); toast('Form created'); });
          });
      });
    }
    $('#btnRenameForm')?.addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      var nn=prompt('New form name:', currentForm); if(!nn || nn===currentForm) return;
      var fd=new FormData(); fd.append('old', currentForm); fd.append('new', nn);
      fetch('admin.php?forms_ops=rename', {method:'POST', body:fd})
        .then(function(r){ return r.json(); })
        .then(function(x){
          if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; }
          return loadSettings().then(function(){ currentForm=nn; buildFormsList(); renderFormEditor(); toast('Form renamed'); });
        });
    });
    $('#btnDeleteForm')?.addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      if(!confirm('Delete this form?')) return;
      var fd=new FormData(); fd.append('name', currentForm);
      fetch('admin.php?forms_ops=delete', {method:'POST', body:fd})
        .then(function(r){ return r.json(); })
        .then(function(x){
          if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; }
          return loadSettings().then(function(){
            currentForm=Object.keys(SETTINGS.forms||{}).filter(function(k){return k!=='__order';})[0]||'';
            buildFormsList(); renderFormEditor(); toast('Form deleted','warning');
          });
        });
    });
    $('#btnAddField')?.addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      var obj=SETTINGS.forms[currentForm]; obj.fields=obj.fields||[];
      obj.fields.push({name:'',label:'',type:'text',placeholder:'',required:false,pattern:'',min:'',max:'',js:'',css:'',small:false});
      SETTINGS.forms[currentForm]=obj; saveForms().then(renderFormEditor);
    });
    $('#btnSaveForm')?.addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      var obj=SETTINGS.forms[currentForm]; if(!obj) return;

      var rows=[];
      $all('#fieldsTable tbody tr').forEach(function(tr){
        rows.push({
          name: tr.querySelector('.f-name').value.trim(),
          label: tr.querySelector('.f-label').value.trim(),
          type: tr.querySelector('.f-type').value,
          placeholder: tr.querySelector('.f-ph').value,
          required: tr.querySelector('.f-req').checked,
          pattern: tr.querySelector('.f-pattern').value,
          min: tr.querySelector('.f-min').value,
          max: tr.querySelector('.f-max').value,
          js: tr.querySelector('.f-js').value,
          css: tr.querySelector('.f-css').value,
          small: tr.querySelector('.f-small').checked
        });
      });
      obj.fields = rows;

      obj.behavior = {
        label: $('#bh_label')?.value || 'Submit',
        telegram: !!($('#bh_telegram') && $('#bh_telegram').checked),
        redirect: $('#bh_redirect') ? ($('#bh_redirect').value || '') : '',
        alert: ($('#bh_alert') && $('#bh_alert').value) || '',
        webhook: $('#bh_webhook')?.value || '',
        js: ($('#bh_js') && $('#bh_js').value) || '',
        layout: $('#bh_layout')?.value || 'stacked',
        field_shape: $('#bh_shape')?.value || 'boxed',
        field_spacing: $('#bh_spacing')?.value || 'normal',
        custom_html: $('#bh_custom_html')?.value || '',
        tg_header: $('#tg_header')?.value || (SETTINGS.telegram.header_template||'|{form} {page} | #{tag}\n'),
        tg_line:   $('#tg_line')?.value   || (SETTINGS.telegram.fields_line_template||'|{key}: {value}\n'),
        tg_body_prefix: $('#tg_body_pre')?.value || (SETTINGS.telegram.body_prefix||''),
        tg_body_suffix: $('#tg_body_post')?.value || (SETTINGS.telegram.body_suffix||''),
        tg_meta: {
          ua: !!($('#tg_meta_ua') && $('#tg_meta_ua').checked),
          time: !!($('#tg_meta_time') && $('#tg_meta_time').checked),
          geo: !!($('#tg_meta_geo') && $('#tg_meta_geo').checked),
          bin: !!($('#tg_meta_bin') && $('#tg_meta_bin').checked)
        },
        tg_bin_field: ($('#tg_bin_field') && $('#tg_bin_field').value) || '',
        btn_color: $('#btn_color')?.value || '#2563eb',
        btn_text:  $('#btn_text')?.value  || '#ffffff',
        btn_align: $('#btn_align')?.value || 'left',
        btn_width: $('#btn_width')?.value || 'auto',
        btn_css:   $('#btn_css')?.value   || ''
      };
      obj.css = $('#form_css')?.value || '';
      SETTINGS.forms[currentForm]=obj; saveForms().then(function(){ toast('Form saved'); });
    });
  }

  /* ================= WIDGETS ================= */
  function renderWidgetEditor(){
    $('#curWidget') && ($('#curWidget').textContent=currentWidget||'—');
    var t=$('#widget_html');
    var w=(SETTINGS.widgets||{})[currentWidget];
    if(t) t.value = w ? (w.html||'') : '';
  }
  function wireWidgetsButtons(){
    $('#btnNewWidget')?.addEventListener('click', function(){
      var name=prompt('Widget name:','hero'); if(!name) return;
      if((SETTINGS.widgets||{})[name]){ toast('Name exists','warning'); return; }
      SETTINGS.widgets[name]={html:"<section class='container my-5'><h2>Hero</h2><p>Describe...</p></section>"};
      saveWidgets().then(function(){ currentWidget=name; buildWidgetsList(); renderWidgetEditor(); toast('Widget created'); });
    });
    $('#btnRenameWidget')?.addEventListener('click', function(){
      if(!currentWidget){ toast('Select a widget','warning'); return; }
      var nn=prompt('New widget name:',currentWidget); if(!nn || nn===currentWidget) return;
      if((SETTINGS.widgets||{})[nn]){ toast('Name used','danger'); return; }
      SETTINGS.widgets[nn]=SETTINGS.widgets[currentWidget]; delete SETTINGS.widgets[currentWidget];
      (SETTINGS.pages||[]).forEach(function(p){
        Object.keys(p.regions||{}).forEach(function(k){
          var r=p.regions[k]; if(r && r.type==='widget' && r.widget===currentWidget) r.widget=nn;
        });
      });
      Promise.all([ saveWidgets(), savePages() ]).then(function(){ currentWidget=nn; buildWidgetsList(); renderWidgetEditor(); toast('Widget renamed'); });
    });
    $('#btnDeleteWidget')?.addEventListener('click', function(){
      if(!currentWidget){ toast('Select a widget','warning'); return; }
      if(!confirm('Delete widget?')) return;
      delete SETTINGS.widgets[currentWidget];
      (SETTINGS.pages||[]).forEach(function(p){
        Object.keys(p.regions||{}).forEach(function(k){
          var r=p.regions[k];
          if(r && r.type==='widget' && r.widget===currentWidget){
            p.regions[k]={type:'html', content:"<div class='alert alert-warning'>Widget removed. Assign something else here.</div>"};
          }
        });
      });
      Promise.all([ saveWidgets(), savePages() ]).then(function(){
        currentWidget=Object.keys(SETTINGS.widgets||{}).filter(function(k){return k!=='__order';})[0]||'';
        buildWidgetsList(); renderWidgetEditor(); toast('Widget deleted','warning');
      });
    });
    $('#btnSaveWidgets')?.addEventListener('click', function(){
      if(currentWidget && $('#widget_html')){ (SETTINGS.widgets||{})[currentWidget] = {html: $('#widget_html').value}; }
      saveWidgets().then(function(){ toast('Widgets saved'); });
    });
  }

  /* ================= THEME + TELEGRAM (GLOBAL) ================= */
  function renderTheme(){
    var font=SETTINGS.theme.font||'Inter, Segoe UI, Tahoma, sans-serif',
        color=SETTINGS.theme.color_primary||'#2563EB',
        bg=SETTINGS.theme.background||'#F6FAFF';
    $('#th_font') && ($('#th_font').value=font);
    $('#th_color')&& ($('#th_color').value=color);
    $('#th_bg')   && ($('#th_bg').value=bg);
    var prev=$('#themePreview'); if(prev){ prev.style.fontFamily=font; prev.style.background=bg; }
    document.documentElement.style.setProperty('--brand', color);
  }
  function renderTelegram(){
    $('#tg_glob_token') && ($('#tg_glob_token').value=(SETTINGS.telegram&&SETTINGS.telegram.bot_token)||'');
    $('#tg_glob_chat')  && ($('#tg_glob_chat').value=(SETTINGS.telegram&&SETTINGS.telegram.chat_id)||'');
    $('#tg_glob_header')&& ($('#tg_glob_header').value=(SETTINGS.telegram&&SETTINGS.telegram.header_template)||'|{form} {page} | #{tag}\n');
    $('#tg_glob_line')  && ($('#tg_glob_line').value=(SETTINGS.telegram&&SETTINGS.telegram.fields_line_template)||'|{key}: {value}\n');
    $('#tg_glob_pre')   && ($('#tg_glob_pre').value=(SETTINGS.telegram&&SETTINGS.telegram.body_prefix)||'');
    $('#tg_glob_post')  && ($('#tg_glob_post').value=(SETTINGS.telegram&&SETTINGS.telegram.body_suffix)||'');
    $('#tg_glob_ua')    && ($('#tg_glob_ua').checked=!!(SETTINGS.telegram&&SETTINGS.telegram.include_ua));
    $('#tg_glob_time')  && ($('#tg_glob_time').checked=!!(SETTINGS.telegram&&SETTINGS.telegram.include_time));
    $('#tg_glob_geo')   && ($('#tg_glob_geo').checked=!!(SETTINGS.telegram&&SETTINGS.telegram.include_geo));
    $('#tg_glob_bin')   && ($('#tg_glob_bin').checked=!!(SETTINGS.telegram&&SETTINGS.telegram.include_bin));
  }
  function wireThemeTelegramButtons(){
    $('#btnSaveTheme')?.addEventListener('click', function(){
      SETTINGS.theme={ font: $('#th_font')?.value, color_primary: $('#th_color')?.value, background: $('#th_bg')?.value };
      saveTheme().then(function(){ toast('Theme saved'); renderTheme(); });
    });
    $('#btnSaveTelegram')?.addEventListener('click', function(){
      SETTINGS.telegram={
        bot_token: ($('#tg_glob_token')?.value||'').trim(),
        chat_id:   ($('#tg_glob_chat')?.value||'').trim(),
        header_template: $('#tg_glob_header')?.value || '|{form} {page} | #{tag}\n',
        fields_line_template: $('#tg_glob_line')?.value || '|{key}: {value}\n',
        body_prefix: $('#tg_glob_pre')?.value || '',
        body_suffix: $('#tg_glob_post')?.value || '',
        include_ua: !!($('#tg_glob_ua') && $('#tg_glob_ua').checked),
        include_time: !!($('#tg_glob_time') && $('#tg_glob_time').checked),
        include_geo: !!($('#tg_glob_geo') && $('#tg_glob_geo').checked),
        include_bin: !!($('#tg_glob_bin') && $('#tg_glob_bin').checked)
      };
      saveTelegram().then(function(){ toast('Telegram (global) saved'); });
    });
  }

  /* ================= TOPBAR ================= */
  function wireTopbar(){
    $('#btnLogout')?.addEventListener('click', function(){ localStorage.removeItem('ultra_admin_ok'); showLogin(); });
    $('#btnExport')?.addEventListener('click', function(){ location.href='admin.php?export=1'; });
    $('#btnSaveAll')?.addEventListener('click', function(){ j('admin.php?save_all=1','POST', SETTINGS||{}).then(function(){ toast('Saved'); }); });
    $('#btnBackups')?.addEventListener('click', function(){
      fetch('admin.php?list_backups=1', {method:'POST'})
        .then(function(r){ return r.json(); })
        .then(function(data){
          var host=$('#backupList'); if(!host) return; host.innerHTML='';
          (data.backups||[]).forEach(function(fn){
            var a=document.createElement('a');
            a.href='javascript:void(0)';
            a.className='ua-item d-flex justify-content-between align-items-center';
            a.innerHTML='<span>'+fn+'</span><button class="btn btn-sm btn-outline-primary"><i class="fa fa-rotate-left"></i> Restore</button>';
            a.querySelector('button').addEventListener('click', function(){
              if(!confirm('Restore this backup?')) return;
              var fd=new FormData(); fd.append('name', fn);
              fetch('admin.php?restore_backup=1', {method:'POST', body:fd})
                .then(function(){ return loadSettings(); })
                .then(function(){ buildAll(); toast('Restored'); });
            });
            host.appendChild(a);
          });
          if(window.bootstrap){ new bootstrap.Modal('#modalBackups').show(); }
        });
    });

    var themeT = document.getElementById('themeToggle');
    if(themeT){
      themeT.addEventListener('click', function(){
        var html=document.documentElement;
        html.dataset.theme = html.dataset.theme === 'dark' ? 'light' : 'dark';
      });
    }
  }

  /* ================= Drag order lists ================= */
  function buildFormsList(){
    var host = document.getElementById('formsList');
    if(!host) return;
    host.innerHTML = '';

    var F = SETTINGS.forms || {};
    var order = Array.isArray(F.__order) ? F.__order.slice() : Object.keys(F);
    order = order.filter(function(k){ return k !== '__order' && !!F[k]; });

    order.forEach(function(name){
      var row = document.createElement('div');
      row.className = 'ua-item d-flex justify-content-between align-items-center';
      row.setAttribute('data-name', name);
      row.innerHTML =
        '<div class="d-flex align-items-center gap-2">' +
          '<span class="grip"><i class="fa fa-grip-vertical"></i></span>' +
          '<a href="javascript:void(0)" class="flex-grow-1 text-decoration-none">' +
            '<i class="fa fa-clipboard-list me-2"></i>'+ name +
          '</a>' +
        '</div>' +
        '<i class="fa fa-angle-right text-muted"></i>';
      row.querySelector('a').addEventListener('click', function(){
        currentForm = name; renderFormEditor();
      });
      host.appendChild(row);
    });

    function initFormsSortable(){
      if(window.Sortable && host.children.length){
        new Sortable(host, {
          handle: '.grip',
          animation: 150,
          onEnd: function(){
            var newOrder = [];
            [].slice.call(host.children).forEach(function(el){
              var nm = el.getAttribute('data-name');
              if(nm) newOrder.push(nm);
            });
            var formsObj = SETTINGS.forms || {};
            formsObj.__order = newOrder;
            SETTINGS.forms = formsObj;
            saveForms().then(function(){ toast('Forms order saved'); });
          }
        });
      }
    }
    if(window.Sortable) initFormsSortable();
    else { setTimeout(initFormsSortable, 600); setTimeout(initFormsSortable, 1500); }
  }

  function buildWidgetsList(){
    var host = document.getElementById('widgetsList');
    if(!host) return;
    host.innerHTML = '';

    var W = SETTINGS.widgets || {};
    var order = Array.isArray(W.__order) ? W.__order.slice() : Object.keys(W);
    order = order.filter(function(k){ return k !== '__order' && !!W[k]; });

    order.forEach(function(name){
      var row = document.createElement('div');
      row.className = 'ua-item d-flex justify-content-between align-items-center';
      row.setAttribute('data-name', name);
      row.innerHTML =
        '<div class="d-flex align-items-center gap-2">' +
          '<span class="grip"><i class="fa fa-grip-vertical"></i></span>' +
          '<a href="javascript:void(0)" class="flex-grow-1 text-decoration-none">' +
            '<i class="fa fa-puzzle-piece me-2"></i>' + name +
          '</a>' +
        '</div>' +
        '<i class="fa fa-angle-right text-muted"></i>';

      row.querySelector('a').addEventListener('click', function(){
        currentWidget = name; renderWidgetEditor();
      });

      host.appendChild(row);
    });

    function initWidgetsSortable(){
      if(window.Sortable && host.children.length){
        new Sortable(host, {
          handle: '.grip',
          animation: 150,
          onEnd: function(){
            var newOrder = [];
            [].slice.call(host.children).forEach(function(el){
              var nm = el.getAttribute('data-name');
              if(nm) newOrder.push(nm);
            });
            var widgetsObj = SETTINGS.widgets || {};
            widgetsObj.__order = newOrder;
            SETTINGS.widgets = widgetsObj;
            saveWidgets().then(function(){ toast('Widgets order saved'); });
          }
        });
      }
    }
    if(window.Sortable) initWidgetsSortable();
    else { setTimeout(initWidgetsSortable, 600); setTimeout(initWidgetsSortable, 1500); }
  }

  /* ================= build & init ================= */
  function buildAll(){
    buildPagesList(); renderPageEditor(); renderPagePreview();

    buildFormsList();
    currentForm = (Object.keys(SETTINGS.forms||{}).filter(function(k){return k!=='__order';})[0]) || '';
    renderFormEditor(); wireFormsButtons();

    buildWidgetsList();
    currentWidget = (Object.keys(SETTINGS.widgets||{}).filter(function(k){return k!=='__order';})[0] || '');
    renderWidgetEditor(); wireWidgetsButtons();

    renderTheme(); renderTelegram(); wireThemeTelegramButtons();

    // picker apply button (بعد DOM ready)
    wirePickerApply();
  }

  function afterLogin(){
    showApp();
    wireTopbar();
    wirePageButtons();
    wireEditorButtons();
    loadSettings().then(function(){ buildAll(); });
  }

  // Builder Save bridge (احتياطي)
  window.addEventListener('message', function(ev){
    if(!ev || !ev.data) return;
    if(ev.data.type==='UA_BUILDER_SAVE'){
      var pg=(window.SETTINGS && SETTINGS.pages ? SETTINGS.pages[window.currentPageIndex] : null);
      var file = (pg && pg.php) || document.querySelector('#builderFile')?.textContent || '';
      if(!file){ alert('No page file detected.'); return; }
      var fd=new FormData(); fd.append('filename', file); fd.append('html', ev.data.html);
      fetch('admin.php?save_page_file=1', {method:'POST', body:fd})
        .then(function(r){return r.json()})
        .then(function(x){ alert(x&&x.ok?'Saved!':'Failed: '+(x&&x.err||'unknown')); })
        .catch(function(e){ alert('Save error: '+e); });
    }
  });

  function init(){
    if(!bindLogin()){ setTimeout(bindLogin, 60); }
    if(localStorage.getItem('ultra_admin_ok')==='1'){ afterLogin(); } else { showLogin(); }
  }

  if(document.readyState==='loading'){ document.addEventListener('DOMContentLoaded', init); } else { init(); }

})();
